grammar VisualBasicComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}
import VisualBasicSharedRulesLexer;

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | conditionals;
anything: .;

// Note that a DO WHILE loop doesn't have to be matched explicitly as the WHILE will capture the complexity.
loops: WHILE | UNTIL | LOOP_UNTIL | FOR;

conditionals: IF | ELSE | SELECT_CASE | logical_operator;

logical_operator: AND | AndAlso | OR | OrElse;
