grammar Go;

import GoSharedRulesLexer;

translationunit
:
	expression* EOF
;

expression : function_declaration
           | variable_declarations
           | top_level_block_statement
           | anything;

anything : ~(LeftBrace | RightBrace);

variable_declarations: consecutive_variables
                     | single_variable
                     | multiple_variables
                     | variable_init_shortcut
                     | const_declaration;

single_variable: VAR variable_name .;
consecutive_variables: VAR consecutive_variables_list .;
consecutive_variables_list : variable_name
                           | consecutive_variables_list ',' variable_name;
// var (
//     a = 5
//     b = 10
//     c = 15
//   )
multiple_variables: VAR LeftParen multiple_variables_declaration_body+ RightParen;
multiple_variables_declaration_body: variable_name '='
                                   | multi_variables_declaration_body_fn_call
                                   | ~(LeftParen | RightParen | FUNCTION);
multi_variables_declaration_body_fn_call: LeftParen ~RightParen*? RightParen;

variable_init_shortcut: variable_name VAR_SHORTCUT .; // x := "Hello World"
const_declaration: CONST variable_name . '=';
variable_name: ID;

top_level_block_statement : LeftBrace (top_level_block_statement | anything)*? RightBrace;

function_declaration : FUNCTION receiver? function_name type_parameters? function_scope;
// Since we don't use the information inside the type parameter list, we completely ignore it.
type_parameters: LeftBracket .+? RightBracket;

function_name: ID;

function_scope: LeftParen function_definition_params_list? RightParen return_type LeftBrace function_body RightBrace;

return_type: ~LeftBrace*?;

function_definition_params_list : function_param ','?
                                | function_definition_params_list ',' function_param ','?
                                ;

function_param : function_param_type
               | ~(',' | RightParen)+?;

function_param_type: ID function_param_type_signature function_param_return_spec? ; // a func(a, b int) int
function_param_type_signature: FUNCTION LeftParen function_definition_params_list? RightParen;
function_param_return_spec: ID | function_param_type_signature;

receiver: LeftParen~(',' | RightParen)+? RightParen;

function_body : function_body_statement*?;

function_body_statement : block_statement
                        | anything;

block_statement : LeftBrace function_body_statement*? RightBrace;


