grammar CppConsecutiveAssertions;

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: assert_start ~(SEMICOLON)+ SEMICOLON;

assert_start: GOOGLE_TEST_ASSERT
            | catch2
            | GENERAL_ASSERT
            | MS_TEST_ASSERT;

GOOGLE_TEST_ASSERT: 'EXPECT_' | 'ASSERT_';

GENERAL_ASSERT: 'ASSERT';

catch2: CATCH2_ASSERT LEFT_BRACE
      | CATCH2_REQUIRE LEFT_BRACE;

CATCH2_ASSERT: 'CHECK'
             | 'CHECK_FALSE'
             | 'CHECK_NOTHROW'
             | 'CHECK_THROWS'
             | 'CHECK_THROWS_AS'
             | 'CHECK_THROWS_WITH'
             | 'CHECK_THROWS_MATCHES'
             | 'CHECK_THAT'; // Catch "matcher" syntax

CATCH2_REQUIRE: 'REQUIRE'
              | 'REQUIRE_FALSE'
              | 'REQUIRE_NOTHROW'
              | 'REQUIRE_THROWS'
              | 'REQUIRE_THROWS_AS'
              | 'REQUIRE_THROWS_WITH'
              | 'REQUIRE_THROWS_MATCHES'
              | 'REQUIRE_THAT'; // Catch "matcher" syntax

MS_TEST_ASSERT: 'Assert::AreEqual'
              | 'Assert::AreNotEqual'
              | 'Assert::AreSame'
              | 'Assert::AreNotSame'
              | 'Assert::IsNull'
              | 'Assert::IsNotNull'
              | 'Assert::IsTrue'
              | 'Assert::IsFalse'
              | 'Assert::Fail'
              | 'Assert::ExpectException';

LEFT_BRACE: '(';
SEMICOLON : ';';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;
Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ANY_CHAR: .;