(ns codescene.features.delta.integration.integration-config
  (:require [clojure.string :as str]
            [medley.core :as m]
            [codescene.features.config.properties :refer [enum bool sval property ival] :as p]))

;; rename log:
;; :delta-ignore-other-branches -> :ignore-other-branches
;; :delta-branch-name-exclusion-pattern -> :branch-name-exclusion-pattern

;; for cloud
;; :delta-analysis-enabled -> ch-enabled on table
;; for coverage :qg-preset -> :cov-qg-preset

;; for onprem
;;

(def prop-ignore-other-branches (property :ignore-other-branches :delta-ignore-other-branches (bool) false))
(def prop-branch-name-exclusion-pattern (property :branch-name-exclusion-pattern :delta-branch-name-exclusion-pattern (sval)))

(def general-delta-properties
  [prop-ignore-other-branches prop-branch-name-exclusion-pattern])

(defn- bitbucket-server-api-url-fix [url]
  (let [slash-trimmed (str/replace-first url #"/+$" "")]
    (if (or (= url "") (str/ends-with? slash-trimmed "/rest/api/1.0"))
      slash-trimmed (str slash-trimmed "/rest/api/1.0"))))

(def onprem-properties
  {:github [(property :secret :github-secret (sval))
            (property :private-key :github-private-key (p/file-string true))
            (property :app-id :github-app-id (sval))
            (property :preset-id :github-preset-id (ival))
            (property :api-url :github-api-url (sval))]
   :github-hook [(property :password :github-deprecated-token (sval true))
                 (property :api-url :github-deprecated-api-url (sval) "")
                 (property :host-url :github-deprecated-host-url (sval))]
   :azure [(property :password :azure-token (sval true))
           (property :api-url :azure-api-url (sval) "")
           (property :preset-id :azure-preset-id (ival))
           (property :host-url :azure-host-url (sval))]
   :bitbucket [(property :password :bitbucket-password (sval true))
               (property :api-url :bitbucket-api-url (sval) "")
               (property :host-url :bitbucket-host-url (sval))
               (property :preset-id :bitbucket-preset-id (ival))
               (property :username :bitbucket-username (sval))]
   :bitbucket-server [(property :password :bitbucket-server-token (sval true))
                      (assoc (property :api-url :bitbucket-server-api-url (sval) "")
                        :fix-fn bitbucket-server-api-url-fix)
                      (property :preset-id :bitbucket-server-preset-id (ival))
                      (property :host-url :bitbucket-server-host-url (sval))]
   :gerrit [(property :password :gerrit-password (sval true))
            (property :api-url :gerrit-api-url (sval) "")
            (property :username :gerrit-username (sval))
            (property :origin-url :gerrit-origin-url (sval))
            (property :host-url :gerrit-host-url (sval))
            (property :preset-id :gerrit-preset-id (ival))
            (property :user-hook? :gerrit-user-hook (bool) false)]
   :plugin-gerrit []
   :none []
   :gitlab [(property :password :gitlab-token (sval true))
            (property :api-url :gitlab-api-url (sval) "")
            (property :host-url :gitlab-host-url (sval))
            (property :preset-id :gitlab-preset-id (ival))]})

(def all-integration-props
  (vec (m/dedupe-by :id (concat general-delta-properties (flatten (vals onprem-properties))))))

