(ns codescene.features.chat.service.llm.provider
  "Protocol definition for LLM providers.
   
   All LLM provider implementations must satisfy this protocol.")

(defprotocol LLMProvider
  "Protocol for LLM chat completion providers."
  
  (call 
    [this config messages]
    "Calls the LLM provider with the given configuration and messages.
     
     Arguments:
     - config: Map with :base-url, :chat-endpoint, :api-key, :model
     - messages: Vector of {:role :content} maps
     
     Returns:
     - success: boolean
     - content: string (only if success is true)
     - usage: 
         - prompt-tokens: int
         - completion-tokens: int
     - error: string (only if success is false)"))
