// @flow
import $ from 'jquery';

import * as tableSorter from 'codescene-ui/src/table-sorter';

type ViewOptions = {
  tableElement: string;
};

export function init(options: ViewOptions) {
  $.tablesorter.addParser({
    id: 'duration',
    is: s => /\d+ min, \d+ sec|\d+ sec/.test(s),
    format: s => s.split(', ').reduce((total, part) => total + (parseInt(part) || 0) * (part.includes('min') ? 60 : 1), 0),
    type: 'numeric'
  });

  tableSorter.sort($(options.tableElement), {
    sortList: [[0]],
    sortInitialOrder: 'asc',
    headers: {
      '1': {
        sorter: false
      }
    }
  });
}
