// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import * as temporalCoupling from 'codescene-ui/src/analyses/change-coupling/temporal-coupling';

type ViewOptions = {
  sumOfCouplingsUrl: string,
};

export function init(options : ViewOptions) {
  xhr.csv(options.sumOfCouplingsUrl)
    .then(data => {
      if (data && data.length > 0) {
        $('#soctable').append(temporalCoupling.drawSumOfCouplingsTable(data));
      } else {
        alerts.warning($('#soctable'), 'No sum of couplings data available.');
      }
    });
}
