grammar CppSharedRulesParser;

import CppSharedRulesLexer;

anything : ~(LeftBrace | RightBrace);

using_namespace : 'using' NAMESPACE (ID | SCOPED_NAME) ';';

namespace_alias : NAMESPACE ID '=' (ID | SCOPED_NAME) ';';

function_name : '~'? (OPERATOR | ID | SCOPED_NAME | SCOPED_OPERATOR);

function_body : function_body_statement*?;

function_body_statement : pre_proc_block
                        | block_statement
                        | using_namespace
                        | namespace_alias
                        | any_statement;

trailing_return_type: ARROW ~(LeftBrace)+?;

block_statement : LeftBrace function_body_statement*? RightBrace;

pre_proc_block : (PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF)
                  pre_proc_condition? pre_proc_block_statement*?
                  (PRE_PROC_ELSE | PRE_PROC_ENDIF | PRE_PROC_ELIF);
pre_proc_block_statement : (PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF)
                            pre_proc_condition? pre_proc_block_statement*? PRE_PROC_ENDIF
                         | ~(PRE_PROC_ENDIF | PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF);
pre_proc_condition : ('!' | '1' | '0' | ID);

any_statement : ~(LeftBrace | RightBrace | NAMESPACE | PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF);

