grammar CStyleComplexity;

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals | operators;
anything: .;

loops: leading_sequence (FOR | WHILE) Whitespace? LEFT_PAREN;

paths: (THROW Whitespace) |
       (CATCH Whitespace? LEFT_PAREN) |
       (CONTINUE Whitespace? SEMICOLON) |
       (GOTO Whitespace);

conditionals: leading_sequence ((IF Whitespace? LEFT_PAREN) |
                                (CASE Whitespace) |
                                (DEFAULT Whitespace? COLON));

operators: OPERATORS;

leading_sequence: Whitespace | NEWLINE;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

IF: 'if';
FOR: 'for' | 'foreach';
WHILE: 'while';
CONTINUE: 'continue';
GOTO: 'goto';
CASE: 'case';
DEFAULT: 'default';
THROW: 'throw';
CATCH: 'catch';
RETURN: 'return';

OPERATORS: '&&' | '||' | '?';

LEFT_PAREN: '(';
COLON: ':';
SEMICOLON: ';';

Whitespace : [ \t]+;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence