grammar ApexComplexity;

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals;
anything: .;

loops: leading_sequence (FOR | WHILE) Whitespace? LEFT_PAREN;

paths: (CATCH Whitespace? LEFT_PAREN) |
       (THROW Whitespace);

conditionals: (leading_sequence (IF Whitespace? LEFT_PAREN) |
                                (WHEN Whitespace))
              | OPERATORS;

leading_sequence: Whitespace | NEWLINE;

fragment ESCAPED : '\\\\' | '\\\'';
LITERAL : '\'' ( ESCAPED | ~('\''))*? '\'';

IF: 'if';
FOR: 'for';
WHILE: 'while';
WHEN: 'when';
CATCH: 'catch';
THROW: 'throw';
RETURN: 'return';

OPERATORS: '&&' | '||' | '?';

LEFT_PAREN: '(';
COLON: ':';
SEMICOLON: ';';

Whitespace : [ \t]+;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence