(ns codescene.features.reports.code-health.project
  (:require
   [codescene.features.dashboard.core :as dashboard-common]
   [codescene.features.factors.results :as results]
   [codescene.features.reports.common.project :as common-project]))


(defn with-results [{:keys [path-fn] :as project}]
  (when path-fn
    (let [absolute-analysis-path (path-fn "")
          {:keys [yearago prev-monthago prev-end-date monthago end-date]} (common-project/periods absolute-analysis-path)
          month-renderable-trends (results/->renderable-trends absolute-analysis-path monthago end-date)
          cleaned-month-trends (common-project/clean-renderable-trends month-renderable-trends :month)
          year-renderable-trends (results/->renderable-trends absolute-analysis-path yearago end-date)
          cleaned-year-trends (common-project/clean-renderable-trends year-renderable-trends :month)
          this-period-statistics (results/period-statistics path-fn monthago end-date)
          previous-period-statistics (results/period-statistics path-fn prev-monthago prev-end-date)]
      (merge project {:file-summary (dashboard-common/file-summary-per-language absolute-analysis-path)
                      :dashboard (dashboard-common/dashboard-data absolute-analysis-path)
                      :period-renderable-trends cleaned-month-trends
                      :year-renderable-trends cleaned-year-trends
                      :this-period-statistics this-period-statistics
                      :previous-period-statistics previous-period-statistics
                      :end end-date
                      :beginning monthago}))))