(ns codescene.features.presentation.factor-metadata
  (:require [codescene.factors.code-health.presentation :as chp]
            [codescene.factors.knowledge.presentation :as kp]
            [codescene.factors.team-code.presentation :as tcp]
            [codescene.factors.delivery.presentation :as dp]))

(def ^:private metadata-map
  {chp/kpi-key (chp/metadata-for chp/kpi-key)
   chp/hotspots-code-health-key (chp/metadata-for chp/hotspots-code-health-key)
   chp/average-code-health-key (chp/metadata-for chp/average-code-health-key)
   chp/worst-performer-key (chp/metadata-for chp/worst-performer-key)

   kp/kpi-key (kp/metadata-for kp/kpi-key)
   kp/knowledge-islands-key (kp/metadata-for kp/knowledge-islands-key)
   kp/code-familiarity-key (kp/metadata-for kp/code-familiarity-key)

   tcp/kpi-key (tcp/metadata-for tcp/kpi-key)
   tcp/team-cohesion-key (tcp/metadata-for tcp/team-cohesion-key)
   tcp/team-coupling-key (tcp/metadata-for tcp/team-coupling-key)

   dp/kpi-key (dp/metadata-for dp/kpi-key)
   dp/development-time-key (dp/metadata-for dp/development-time-key)
   dp/unplanned-work-key (dp/metadata-for dp/unplanned-work-key)})

(defn- metadata-for*
  [factor-key]
  (get metadata-map factor-key))

(defn metadata-for
  "Returns metadata or nil for kpis and sub-kpis.
   Used for getting display names and score levels used mainly for scoring kpi values,
   but also for rendering the score-legend in the UI."
  [factor-key]
  #?(:clj  (metadata-for* factor-key)
     :cljs (clj->js (metadata-for* (keyword factor-key)))))

(comment
  (metadata-for :team-code-alignment))