(ns codescene.features.chat.service.mcp.session
  "MCP session management.
   
   Handles session storage and retrieval for MCP server communication.
   Sessions are stored per auth-token to support multiple concurrent users.")

(def ^:private default-mcp-url "http://localhost:9999/mcp")

(def ^:private sessions
  "Atom storing session IDs keyed by auth-token (or :anonymous for unauthenticated)."
  (atom {}))

(defn get-mcp-url
  "Returns the MCP server URL from environment or default."
  []
  (or (System/getenv "CODESCENE_MCP_URL") default-mcp-url))

(defn get-session
  "Retrieves the session ID for the given auth-token.
   Returns nil if no session exists."
  [auth-token]
  (get @sessions (or auth-token :anonymous)))

(defn set-session!
  "Stores a session ID for the given auth-token."
  [auth-token session-id]
  (swap! sessions assoc (or auth-token :anonymous) session-id))

(defn reset-session!
  "Clears the session for the given auth-token."
  [auth-token]
  (swap! sessions dissoc (or auth-token :anonymous)))

(defn reset-all-sessions!
  "Clears all sessions. Intended for testing."
  []
  (reset! sessions {}))
