(ns codescene.features.chat.service.mcp.server
  "MCP Server protocol definition.")

(defprotocol MCPServer
  (server-name [this]
    "Returns the keyword identifier for this MCP server (e.g. :codescene).")
  
  (list-tools [this context]
    "Lists available tools. Context has :auth-token, :instance-url, :config.")
  
  (list-prompts [this context]
    "Lists available prompts. Context has :auth-token, :instance-url, :config.
     Returns a vector of prompt maps with :name, :description, and optional :arguments.")
  
  (get-prompt [this context]
    "Gets a specific prompt with arguments applied. 
     Context has :auth-token, :instance-url, :prompt-name, :arguments, :config.
     Returns the prompt messages ready to be used in a conversation.")
  
  (execute-tool [this context]
    "Executes a tool. Context has :auth-token, :instance-url, :tool-name, :arguments, :config."))
