// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as distributionGraph from 'codescene-ui/src/analyses/distribution-graph';
import * as alerts from 'codescene-ui/src/alerts';

export type ViewOptions = {
  projectId : number,
  analysisId : number,
  fileChangeDistributionUrl : string,
  scopeName : string
};

export function init(options : ViewOptions) {
  const content = $('.change-frequency-distribution-view .content');
  const progressIndicator = alerts.progress(content, 'Loading...');

  xhr.csv(options.fileChangeDistributionUrl)
    .then(data => {
      distributionGraph.draw(content, data, options.scopeName);
    })
    .catch(e => {
      console.error(e.stack);
      alerts.error(content, 'Failed to load change frequency distribution data.');
    })
    .then(() => {
      progressIndicator.remove();
    });
}
