-- name: delete-all-analyses!
-- Deletes all existing analyses.
delete from deltaanalysisresults;

-- name: delete-analysis-by-id!
delete from deltaanalysisresults where analysisid = ?;

-- name: delete-all-analyses-for-project!
-- Deletes all existing analyses for a specific project.
delete from deltaanalysisresults where project_id = ?;


-- name: delta-by-analysis-id
-- Returns the analysis matching the given delta analysis ID.
select * from deltaanalysisresults
       where analysisid = :analysis_id and project_id = :project_id;

-- name: delta-by-id
-- Returns the delta matching the given ID.
select * from deltaanalysisresults
       where id = :id and project_id = :project_id;

-- name: latest-delta-analyses-by-project
-- Returns the analysis matching the given project ID.
select * from deltaanalysisresults
       where project_id = ?
       order by analysistime desc;

-- name: latest-delta-analysis-for-project
-- Returns the latest delta analysis matching the given project ID.
select * from deltaanalysisresults
       where project_id = ?
       order by id desc
       limit 1;

-- name: latest-delta-analysis-for-all-projects
-- Returns the most recent delta analysis for each project.
-- This is an optimized query used by projects list page to avoid N+1 queries.
select dar.project_id, dar.analysistime
from deltaanalysisresults dar
where id in (select max(id) from deltaanalysisresults dar2 group by dar2.project_id);

-- name: delta-analyses-by-external-review-id
-- Returns the analysis matching the given project/repo/external-review-id.
select * from deltaanalysisresults
       where project_id = :project_id and repository = :repository and external_review_id = :external_review_id
       order by analysistime desc;

-- name: delta-analyses-by-id-and-repo
-- Returns the analysis matching the given repo/external-review-id/analysis-id.
select * from deltaanalysisresults
where analysisid = :analysisid and repository = :repository
order by analysistime desc;

-- name: gerrit-errors-by-id-and-repo
-- Returns the analysis matching the given repo/external-review-id/analysis-id.
select * from gerrit_errors
where analysisid = :analysisid and repository = :repository
order by created_at desc;

-- name: insert-gerrit-error!
-- Inserts a gerrit error or a skip
insert into gerrit_errors
(parameters, analysisid, created_at, repository, result, project_id)
values
(:parameters, :analysisid, :created_at, :repository, :result, :project_id);

-- name: old-delta-analyses-for-project
-- Returns the analyses older than the given date/time for a project.
select * from deltaanalysisresults
       where project_id = ? AND
       analysistime < :oldesttime;

-- name: insert-delta-analysis!
-- Inserts the given delta analysis results.
insert into deltaanalysisresults
       (resultpath, analysisid, analysistime, repository, external_review_id, description, project_id, provider_ref)
       values(:resultpath, :analysisid, :analysistime, :repository, :external_review_id, :description, :project_id, :provider_ref);

-- name: update-delta-analysis!
-- Updates the given delta analysis results.
update deltaanalysisresults
set resultpath = :resultpath, analysisid = :analysisid, analysistime = :analysistime, repository = :repository,
    external_review_id = :external_review_id, description = :description, provider_ref = :provider_ref
where analysisid = :analysisid and project_id = :project_id;

-- name: insert-pr-trends!
-- Inserts the given pr trends.
insert into pr_trends
       (pr_trends, project_id)
       values(:pr_trends, :project_id);

-- name: delete-pr-trends-by-project-id!
-- Deletes all existing analyses for a specific project.
delete from pr_trends where project_id = ?;

-- name: delete-gerrit-error!
-- Deletes
delete from gerrit_errors where project_id = :project_id and analysisid = :analysisid;

-- name: pr-trends-by-project-id
-- Returns the pr trends matching the given project ID.
select * from pr_trends
       where project_id = ?;
