grammar PerlNestedComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import PerlSharedRulesLexer;

method
:
	expression* EOF
;

expression : complexity
           | block_expression
           | anything;

complexity: general_rules
          | special_rules;

block_expression: LeftBrace expression*? RightBrace;

variable_block_style: LeftBrace variable_block_style_name RightBrace; // %{$LinkTypeList}
variable_block_style_name: ('%' | '@' | '$')? ID;

value_ranges: '%' LeftBrace value_ranges_body*? RightBrace;
value_ranges_body: value_ranges
                 | variable_block_style
                 | block_expression
                 | anything;

anything: ~(LeftBrace | RightBrace);

general_rules: (IF | ELSIF | UNLESS | SWITCH | WHILE | UNTIL | FOR) some_condition complexity_body;

special_rules: for_rule | else_rule | foreach_rule | do_while;

for_rule: FOR 'my' conditions+? complexity_body;
else_rule: ELSE complexity_body;
foreach_rule: FOREACH ~(LeftParen)*? some_condition complexity_body;
do_while: DO complexity_body WHILE;

complexity_body: multi_line_conditional_expression;
multi_line_conditional_expression: LeftBrace expression*? RightBrace;

some_condition: LeftParen conditions+? RightParen;
conditions : conditional_operator
           | value_ranges
           | variable_block_style
           | ~(LeftParen | RightParen)
           | LeftParen conditions*? RightParen;

conditional_operator: OPERATORS;
