(ns codescene.features.pm-data.shortcut.shortcut-ticket-id-extractor
  "This namespace contains fns handling ticket id extraction from commit messages."
  (:require [clojure.string :as str]))

(def ticket-id-pattern #"(?i)\[(sc-\d+)]") ;; match ids like sc-123 inside brackets

(defn extract-ticket-ids [msg]
  (->> (re-seq ticket-id-pattern msg)
       (map second)
       (map str/lower-case)))

(defn make-ticket-id-extractor
  "Creates an extractor that matches ticket ids for the configured Trello boards."
  []
  (fn [_rev _date-time msg]
    (extract-ticket-ids msg)))

(comment 
  (extract-ticket-ids "[sc-234] [sC-456]"))