-- :name get-open-prs :? :*
SELECT * FROM project_open_prs WHERE project_id = :project_id;

-- :name get-open-pr :? :1
SELECT * FROM project_open_prs WHERE project_id = :project_id and repo_id = :repo_id and pr_id = :pr_id;

-- :name insert-open-pr! :insert
INSERT INTO project_open_prs
(
    project_id,
    repo_id,
    pr_id,
    sha
)
VALUES (:project_id,
        :repo_id,
        :pr_id,
        :sha);

-- :name update-open-pr! :! :n
UPDATE project_open_prs SET sha = :sha
    WHERE project_id = :project_id AND repo_id = :repo_id AND pr_id = :pr_id

-- :name delete-open-pr! :! :n
delete from project_open_prs where project_id = :project_id AND repo_id = :repo_id AND pr_id = :pr_id
