-- :name insert-results :insert
INSERT INTO project_coverage_results
(
    project_id,
    repo_id,
    commit_sha,
    base_ref,
    coverage_results,
    metadata
)
VALUES (:project_id,
        :repo_id,
        :commit_sha,
        :base_ref,
        :coverage_results,
        :metadata
       );

-- :name update-results :! :1
UPDATE project_coverage_results
SET coverage_results = :coverage_results,
    modified_at = CURRENT_TIMESTAMP()
--~ (when (contains? params :metadata) ", metadata = :metadata")
WHERE project_id = :project_id AND repo_id = :repo_id
  AND commit_sha = :commit_sha AND base_ref = :base_ref;

-- :name get-check :? :1
SELECT * FROM project_coverage_results
WHERE project_id = :project_id AND repo_id = :repo_id
  AND commit_sha = :commit_sha AND base_ref = :base_ref;

-- :name get-check-by-id :? :1
SELECT * FROM project_coverage_results
WHERE id = :id;

-- :name get-code-coverage-results :? :*
SELECT * FROM project_coverage_results
WHERE project_id = :project_id and created_at between :from and :to