// @flow
import $ from 'jquery';

function clearProxySettings() {
  if (!confirm('Are you sure you want to clear proxy settings?')) {
    return false;
  }

  $.ajax({
    type: 'POST',
    url: window.baseUrl + 'configuration/proxy/update',
    data: { 'host': '', 'port': '', 'user':'', 'password':''},
    success: function() {
      $('input[name=proxy-host]').val('');
      $('input[name=proxy-port]').val('');
      $('input[name=proxy-user]').val('');
      $('input[name=proxy-password]').val('');
    },
    error: function() {
      alert('Failed to clear proxy settings.');
    }
  });
  return true;
}

export function init() {
  $('.clear-proxy').on('click', clearProxySettings);
}
