// @flow
import $ from 'jquery';
import d3 from 'd3';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';

import * as modusOperandiTrends from './modus-operandi-trends';
import * as workTypeTrend from 'codescene-ui/src/analyses/work-type-trend/work-type-trend';

const parseDate = d3.time.format('%Y-%m-%d').parse;

export function parseRow(row : any) {
  return {
    date: parseDate(row.date),
    nrevisions: parseInt(row.nrevisions),
    addedcode: parseFloat(row.addedcode)
  };
}

type ViewOptions = {
  commitMessageTrendUrl : string,
  commitMessagePattern : string
};
export function init(options : ViewOptions) {
  const body = $('.modus-operandi-view');
  xhr.csv(options.commitMessageTrendUrl, parseRow)
    .then(data => {
      if (typeof data !== 'undefined' && data.length > 0) {
        modusOperandiTrends.drawCommitMessageTrend($('#commit-message-line'), data, options.commitMessagePattern);
        modusOperandiTrends.drawCodeChurnTrend($('#code-message-line'), data, options.commitMessagePattern);
      } else {
        const content = $('.content');
        content
          .addClass('text-muted')
          .html('This analysis has no data for commit messages. Configure the project with an expression to match with commit messages.');
      }
    })
    .catch(err => {
      console.error(err);
      alerts.error(body, 'This analysis does not have any commit message trends');
    });
}

function parseTotal(row) {
  var total = 0;
  var parsed = {
    date: parseDate(row.date),
    total: 0
  };
  Object.keys(row)
    .filter(key => key !== 'date')
    .forEach(key => {
      const value = parseInt(row[key]);

      parsed[key] = value;

      total += value;
    });
  parsed.total = total;
  return parsed;
}

type ModusSubTrendsViewOptions = {
  commitMessageSubTrendsUrl : string,
  trendElement: string,
  trendElementProgress: string
};

export function initSubTrends(options : ModusSubTrendsViewOptions) {
  const progressIndicator = alerts.progress($(options.trendElementProgress), 'Loading commit trends...');

  const workTypeTrendPromise = xhr.csv(options.commitMessageSubTrendsUrl, function(r) { return parseTotal(r); })
    .then(data => {
      workTypeTrend.displayTrendFrom(
        $(options.trendElement),
        workTypeTrend.mergeCommitMessageDataByInterval(data, 'week'),
        'weeks'
      );
    })
    .catch(err => {
      console.error(err.stack);
      alerts.warning($(options.trendElement), 'No modus operandi sub-trends available.');
    });

  Promise.all([workTypeTrendPromise])
    .then(() => {
      progressIndicator.remove();
    });
}

