// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as tabulator from 'codescene-ui/src/tabulator';
import * as alerts from 'codescene-ui/src/alerts';
import * as tableSorter from 'codescene-ui/src/table-sorter';

import * as authorTimeline from 'codescene-ui/src/analyses/author-timeline';
import type {AuthorTimeLine} from 'codescene-ui/src/analyses/author-timeline';

type ViewOptions = {
  authorChurnUrl : string
};

function renderTable(container, data) {
  data.forEach(function(d) {
    d.added = d.added.toLocaleString([], { useGrouping: true });
    d.deleted = d.deleted.toLocaleString([], { useGrouping: true });
    d.net = d.net.toLocaleString([], { useGrouping: true });
  });
  var fileTable = tabulator
    .tabulate(container.get(0), data, ['author','added','deleted','net','revisions','months','lastcontrib'])
    .attr('id', 'author-statistics-table')
    .classed('table-hover', true);

  fileTable.selectAll('thead th')
    .text(function(column, i) {
      if (i === 6) {
        return 'Last Contribution';
      }

      return column.charAt(0).toUpperCase() + column.substr(1);
    });

  tableSorter.sort($(fileTable.node()), {
    sortList: [[4, 1]],
    sortInitialOrder: 'desc'
  });
}

function parseRow(row) {
  return {
    author: row.author,
    added: parseInt(row.added),
    deleted: parseInt(row.deleted),
    net: parseInt(row.net),
    revisions: parseInt(row.revisions),
    months: parseInt(row.months),
    lastcontrib: row.lastcontrib
  };
}

export function init(options : ViewOptions) {
  const container = $('#tableview');

  xhr.csv(options.authorChurnUrl, parseRow)
    .then(data => {
      renderTable(container, data);
    })
    .catch(err => {
      console.error(err);
      alerts.error(container, 'Failed to get author churn data.');
    });
}

export function initTimeline(options : AuthorTimeLine) {
  authorTimeline.drawTimeLinesFor(options);
}
