lexer grammar ScalaSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;

CLASS : 'class';
OBJECT : 'object';
TRAIT : 'trait';
DEF : 'def';
VAL: 'val';
VAR: 'var';

IT: 'it';
SHOULD: 'should';
DESCRIBE: 'describe';
SCENARIO: 'scenario';
FEATURE: 'feature';
TEST: 'test';
IGNORE: 'ignore';

FINALLY : 'finally';
FINAL : 'final';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

LeftSquare: '[';
RightSquare: ']';

ARROW : '=>';
STAR: '*';

SEMICOLON : ';';
COLON: ':';

GREATER_GREATER: '>>';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

// Tokens to detect scalatest
IMPORT: 'import';
SCALA_TEST: 'org.scalatest';
SPEC2_TEST: '.specs2';
IN: 'in';

ID_WORD: [a-zA-Z][a-zA-Z_0-9]*;
ID_SPECIAL: [a-zA-Z_][a-zA-Z_0-9]*
          | [+-/^%=:]+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
