;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.license-manager.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.license-manager/GetLicenseAssetRulesetRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseAssetRulesetRequest/LicenseAssetRulesetArn]))

(s/def
  :cognitect.aws.license-manager/ExtendLicenseConsumptionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ExtendLicenseConsumptionResponse/LicenseConsumptionToken
     :cognitect.aws.license-manager.ExtendLicenseConsumptionResponse/Expiration]))

(s/def
  :cognitect.aws.license-manager/OrRuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.OrRuleStatement/MatchingRuleStatements
     :cognitect.aws.license-manager.OrRuleStatement/ScriptRuleStatements]))

(s/def
  :cognitect.aws.license-manager/ExtendLicenseConsumptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ExtendLicenseConsumptionRequest/LicenseConsumptionToken]
    :opt-un
    [:cognitect.aws.license-manager.ExtendLicenseConsumptionRequest/DryRun]))

(s/def
  :cognitect.aws.license-manager/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.TagResourceRequest/ResourceArn
     :cognitect.aws.license-manager.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.license-manager/ProductInformationList
  (s/coll-of :cognitect.aws.license-manager/ProductInformation))

(s/def
  :cognitect.aws.license-manager/EntitlementUsageList
  (s/coll-of :cognitect.aws.license-manager/EntitlementUsage))

(s/def
  :cognitect.aws.license-manager/ResourceType
  (s/spec
    string?
    :gen
    #(s/gen #{"RDS" "EC2_HOST" "SYSTEMS_MANAGER_MANAGED_INSTANCE" "EC2_AMI" "EC2_INSTANCE"})))

(s/def
  :cognitect.aws.license-manager/CreateLicenseConversionTaskForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/ResourceArn
     :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/SourceLicenseContext
     :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/DestinationLicenseContext]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseAssetRulesetRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteLicenseAssetRulesetRequest/LicenseAssetRulesetArn]))

(s/def
  :cognitect.aws.license-manager/ManagedResourceSummary
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ManagedResourceSummary/AssociationCount
     :cognitect.aws.license-manager.ManagedResourceSummary/ResourceType]))

(s/def
  :cognitect.aws.license-manager/ListAssetsForLicenseAssetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/LicenseAssetGroupArn
     :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/AssetType]
    :opt-un
    [:cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/NextToken
     :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroup
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.LicenseAssetGroup/Name
     :cognitect.aws.license-manager.LicenseAssetGroup/AssociatedLicenseAssetRulesetARNs
     :cognitect.aws.license-manager.LicenseAssetGroup/LicenseAssetGroupArn
     :cognitect.aws.license-manager.LicenseAssetGroup/Status]
    :opt-un
    [:cognitect.aws.license-manager.LicenseAssetGroup/StatusMessage
     :cognitect.aws.license-manager.LicenseAssetGroup/LatestResourceDiscoveryTime
     :cognitect.aws.license-manager.LicenseAssetGroup/Description
     :cognitect.aws.license-manager.LicenseAssetGroup/Properties
     :cognitect.aws.license-manager.LicenseAssetGroup/LatestUsageAnalysisTime
     :cognitect.aws.license-manager.LicenseAssetGroup/LicenseAssetGroupConfigurations]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseArn
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseName
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/ProductName
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/Issuer
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/HomeRegion
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/Validity
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/Entitlements
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/ConsumptionConfiguration
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/Status
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseMetadata
     :cognitect.aws.license-manager.CreateLicenseVersionRequest/SourceVersion]))

(s/def :cognitect.aws.license-manager/GrantList (s/coll-of :cognitect.aws.license-manager/Grant))

(s/def
  :cognitect.aws.license-manager/ListReceivedLicensesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedLicensesResponse/NextToken
     :cognitect.aws.license-manager.ListReceivedLicensesResponse/Licenses]))

(s/def
  :cognitect.aws.license-manager/GetLicenseConversionTaskResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.GetLicenseConversionTaskResponse/EndTime
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/StartTime
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/StatusMessage
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/Status
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/DestinationLicenseContext
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/LicenseConversionTaskId
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/SourceLicenseContext
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/ResourceArn
     :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/LicenseConversionTime]))

(s/def
  :cognitect.aws.license-manager/GetAccessTokenRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetAccessTokenRequest/Token]
    :opt-un
    [:cognitect.aws.license-manager.GetAccessTokenRequest/TokenProperties]))

(s/def
  :cognitect.aws.license-manager/AcceptGrantResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.AcceptGrantResponse/Status
     :cognitect.aws.license-manager.AcceptGrantResponse/GrantArn
     :cognitect.aws.license-manager.AcceptGrantResponse/Version]))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationUsage
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceStatus
     :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceType
     :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceArn
     :cognitect.aws.license-manager.LicenseConfigurationUsage/AssociationTime
     :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceOwnerId
     :cognitect.aws.license-manager.LicenseConfigurationUsage/ConsumedLicenses]))

(s/def
  :cognitect.aws.license-manager/StatusReasonMessage
  (s/spec #(re-matches (re-pattern "[\\s\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.license-manager/ListAssetsForLicenseAssetGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupResponse/NextToken
     :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupResponse/Assets]))

(s/def
  :cognitect.aws.license-manager/ListLicenseVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseVersionsResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseVersionsResponse/Licenses]))

(s/def
  :cognitect.aws.license-manager/Tag
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.Tag/Key :cognitect.aws.license-manager.Tag/Value]))

(s/def
  :cognitect.aws.license-manager/ListReceivedGrantsForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedGrantsForOrganizationResponse/Grants
     :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/ListReceivedGrantsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedGrantsResponse/Grants
     :cognitect.aws.license-manager.ListReceivedGrantsResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseSpecificationsForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/RemoveLicenseSpecifications
     :cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/AddLicenseSpecifications]))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseAssetGroupResponse
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetGroupResponse/LicenseAssetGroupArn
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupResponse/Status]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetRule
  (s/keys :req-un [:cognitect.aws.license-manager.LicenseAssetRule/RuleStatement]))

(s/def
  :cognitect.aws.license-manager/LicenseUsageException
  (s/keys :opt-un [:cognitect.aws.license-manager.LicenseUsageException/Message]))

(s/def
  :cognitect.aws.license-manager/AcceptGrantRequest
  (s/keys :req-un [:cognitect.aws.license-manager.AcceptGrantRequest/GrantArn]))

(s/def
  :cognitect.aws.license-manager/ListDistributedGrantsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListDistributedGrantsResponse/Grants
     :cognitect.aws.license-manager.ListDistributedGrantsResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/CheckoutLicenseResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CheckoutLicenseResponse/IssuedAt
     :cognitect.aws.license-manager.CheckoutLicenseResponse/EntitlementsAllowed
     :cognitect.aws.license-manager.CheckoutLicenseResponse/CheckoutType
     :cognitect.aws.license-manager.CheckoutLicenseResponse/NodeId
     :cognitect.aws.license-manager.CheckoutLicenseResponse/LicenseConsumptionToken
     :cognitect.aws.license-manager.CheckoutLicenseResponse/LicenseArn
     :cognitect.aws.license-manager.CheckoutLicenseResponse/Expiration
     :cognitect.aws.license-manager.CheckoutLicenseResponse/SignedToken]))

(s/def
  :cognitect.aws.license-manager/CreateGrantVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateGrantVersionRequest/ClientToken
     :cognitect.aws.license-manager.CreateGrantVersionRequest/GrantArn]
    :opt-un
    [:cognitect.aws.license-manager.CreateGrantVersionRequest/Status
     :cognitect.aws.license-manager.CreateGrantVersionRequest/StatusReason
     :cognitect.aws.license-manager.CreateGrantVersionRequest/GrantName
     :cognitect.aws.license-manager.CreateGrantVersionRequest/SourceVersion
     :cognitect.aws.license-manager.CreateGrantVersionRequest/AllowedOperations
     :cognitect.aws.license-manager.CreateGrantVersionRequest/Options]))

(s/def
  :cognitect.aws.license-manager/IssuerDetails
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.IssuerDetails/KeyFingerprint
     :cognitect.aws.license-manager.IssuerDetails/SignKey
     :cognitect.aws.license-manager.IssuerDetails/Name]))

(s/def
  :cognitect.aws.license-manager/ConsumedLicenseSummary
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ConsumedLicenseSummary/ResourceType
     :cognitect.aws.license-manager.ConsumedLicenseSummary/ConsumedLicenses]))

(s/def :cognitect.aws.license-manager/TagResourceResponse (s/keys))

(s/def :cognitect.aws.license-manager/UpdateLicenseManagerReportGeneratorResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/PrincipalArnList
  (s/coll-of :cognitect.aws.license-manager/Arn :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.license-manager/ProvisionalConfiguration
  (s/keys :req-un [:cognitect.aws.license-manager.ProvisionalConfiguration/MaxTimeToLiveInMinutes]))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseAssetRulesetResponse
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetRulesetResponse/LicenseAssetRulesetArn]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseAssetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteLicenseAssetGroupRequest/LicenseAssetGroupArn]))

(s/def :cognitect.aws.license-manager/ArnList (s/coll-of :cognitect.aws.license-manager/Arn))

(s/def
  :cognitect.aws.license-manager/FilterValues
  (s/coll-of :cognitect.aws.license-manager/FilterValue))

(s/def
  :cognitect.aws.license-manager/LicenseSpecification
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.LicenseSpecification/LicenseConfigurationArn]
    :opt-un
    [:cognitect.aws.license-manager.LicenseSpecification/AmiAssociationScope]))

(s/def
  :cognitect.aws.license-manager/NoEntitlementsAllowedException
  (s/keys :opt-un [:cognitect.aws.license-manager.NoEntitlementsAllowedException/Message]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseAssetGroupResponse
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseAssetGroupResponse/LicenseAssetGroupArn
     :cognitect.aws.license-manager.CreateLicenseAssetGroupResponse/Status]))

(s/def
  :cognitect.aws.license-manager/EntitlementUsage
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.EntitlementUsage/Name
     :cognitect.aws.license-manager.EntitlementUsage/ConsumedValue
     :cognitect.aws.license-manager.EntitlementUsage/Unit]
    :opt-un
    [:cognitect.aws.license-manager.EntitlementUsage/MaxCount]))

(s/def
  :cognitect.aws.license-manager/Filter
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.Filter/Values :cognitect.aws.license-manager.Filter/Name]))

(s/def
  :cognitect.aws.license-manager/Issuer
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.Issuer/Name]
    :opt-un
    [:cognitect.aws.license-manager.Issuer/SignKey]))

(s/def
  :cognitect.aws.license-manager/ProductCodeId
  (s/spec #(re-matches (re-pattern "^[A-Za-z0-9]{1,25}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.license-manager/ReportGeneratorName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.license-manager/ReportType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LicenseConfigurationUsageReport"
        "LicenseConfigurationSummaryReport"
        "LicenseAssetGroupUsageReport"})))

(s/def :cognitect.aws.license-manager/CheckInLicenseResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/LicenseConversionTasks
  (s/coll-of :cognitect.aws.license-manager/LicenseConversionTask))

(s/def :cognitect.aws.license-manager/Message string?)

(s/def
  :cognitect.aws.license-manager/GetLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseRequest/LicenseArn]
    :opt-un
    [:cognitect.aws.license-manager.GetLicenseRequest/Version]))

(s/def
  :cognitect.aws.license-manager/ProductCodeList
  (s/coll-of :cognitect.aws.license-manager/ProductCodeListItem))

(s/def
  :cognitect.aws.license-manager/RedirectException
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.RedirectException/Location
     :cognitect.aws.license-manager.RedirectException/Message]))

(s/def
  :cognitect.aws.license-manager/ListTokensResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListTokensResponse/Tokens
     :cognitect.aws.license-manager.ListTokensResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseManagerReportGeneratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn
     :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportGeneratorName
     :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/Type
     :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportContext
     :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportFrequency
     :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/Description]))

(s/def
  :cognitect.aws.license-manager/ListDistributedGrantsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListDistributedGrantsRequest/GrantArns
     :cognitect.aws.license-manager.ListDistributedGrantsRequest/NextToken
     :cognitect.aws.license-manager.ListDistributedGrantsRequest/Filters
     :cognitect.aws.license-manager.ListDistributedGrantsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseConfigurationResponse/LicenseConfigurationArn]))

(s/def
  :cognitect.aws.license-manager/LicenseStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"PENDING_AVAILABLE"
        "PENDING_DELETE"
        "EXPIRED"
        "AVAILABLE"
        "DEACTIVATED"
        "DELETED"
        "SUSPENDED"})))

(s/def
  :cognitect.aws.license-manager/ValidationException
  (s/keys :opt-un [:cognitect.aws.license-manager.ValidationException/Message]))

(s/def
  :cognitect.aws.license-manager/AccessDeniedException
  (s/keys :opt-un [:cognitect.aws.license-manager.AccessDeniedException/Message]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseAssetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Name
     :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/LicenseAssetGroupConfigurations
     :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/AssociatedLicenseAssetRulesetARNs
     :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Tags
     :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Description
     :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Properties]))

(s/def
  :cognitect.aws.license-manager/CheckInLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CheckInLicenseRequest/LicenseConsumptionToken]
    :opt-un
    [:cognitect.aws.license-manager.CheckInLicenseRequest/Beneficiary]))

(s/def
  :cognitect.aws.license-manager/EntitlementNotAllowedException
  (s/keys :opt-un [:cognitect.aws.license-manager.EntitlementNotAllowedException/Message]))

(s/def :cognitect.aws.license-manager/TagList (s/coll-of :cognitect.aws.license-manager/Tag))

(s/def
  :cognitect.aws.license-manager/LicenseConversionTaskStatus
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.license-manager/CreateGrantRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateGrantRequest/ClientToken
     :cognitect.aws.license-manager.CreateGrantRequest/GrantName
     :cognitect.aws.license-manager.CreateGrantRequest/LicenseArn
     :cognitect.aws.license-manager.CreateGrantRequest/Principals
     :cognitect.aws.license-manager.CreateGrantRequest/HomeRegion
     :cognitect.aws.license-manager.CreateGrantRequest/AllowedOperations]
    :opt-un
    [:cognitect.aws.license-manager.CreateGrantRequest/Tags]))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationAssociation
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceType
     :cognitect.aws.license-manager.LicenseConfigurationAssociation/AmiAssociationScope
     :cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceArn
     :cognitect.aws.license-manager.LicenseConfigurationAssociation/AssociationTime
     :cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceOwnerId]))

(s/def
  :cognitect.aws.license-manager/ConsumptionConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ConsumptionConfiguration/ProvisionalConfiguration
     :cognitect.aws.license-manager.ConsumptionConfiguration/RenewType
     :cognitect.aws.license-manager.ConsumptionConfiguration/BorrowConfiguration]))

(s/def
  :cognitect.aws.license-manager/ReportGenerator
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ReportGenerator/LastRunFailureReason
     :cognitect.aws.license-manager.ReportGenerator/LastRunStatus
     :cognitect.aws.license-manager.ReportGenerator/LastReportGenerationTime
     :cognitect.aws.license-manager.ReportGenerator/Tags
     :cognitect.aws.license-manager.ReportGenerator/ReportContext
     :cognitect.aws.license-manager.ReportGenerator/LicenseManagerReportGeneratorArn
     :cognitect.aws.license-manager.ReportGenerator/ReportCreatorAccount
     :cognitect.aws.license-manager.ReportGenerator/Description
     :cognitect.aws.license-manager.ReportGenerator/ReportFrequency
     :cognitect.aws.license-manager.ReportGenerator/ReportType
     :cognitect.aws.license-manager.ReportGenerator/S3Location
     :cognitect.aws.license-manager.ReportGenerator/CreateTime
     :cognitect.aws.license-manager.ReportGenerator/ReportGeneratorName]))

(s/def
  :cognitect.aws.license-manager/ListAssociationsForLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/LicenseConfigurationArn]
    :opt-un
    [:cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/NextToken
     :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/GrantedLicenseList
  (s/coll-of :cognitect.aws.license-manager/GrantedLicense))

(s/def
  :cognitect.aws.license-manager/ListResourceInventoryResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListResourceInventoryResponse/NextToken
     :cognitect.aws.license-manager.ListResourceInventoryResponse/ResourceInventoryList]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetRulesetList
  (s/coll-of :cognitect.aws.license-manager/LicenseAssetRuleset))

(s/def
  :cognitect.aws.license-manager/EntitlementList
  (s/coll-of :cognitect.aws.license-manager/Entitlement))

(s/def
  :cognitect.aws.license-manager/GrantStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DISABLED"
        "PENDING_ACCEPT"
        "PENDING_DELETE"
        "WORKFLOW_COMPLETED"
        "FAILED_WORKFLOW"
        "PENDING_WORKFLOW"
        "REJECTED"
        "ACTIVE"
        "DELETED"})))

(s/def :cognitect.aws.license-manager/BoxBoolean boolean?)

(s/def
  :cognitect.aws.license-manager/Entitlement
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.Entitlement/Name
     :cognitect.aws.license-manager.Entitlement/Unit]
    :opt-un
    [:cognitect.aws.license-manager.Entitlement/MaxCount
     :cognitect.aws.license-manager.Entitlement/Overage
     :cognitect.aws.license-manager.Entitlement/Value
     :cognitect.aws.license-manager.Entitlement/AllowCheckIn]))

(s/def
  :cognitect.aws.license-manager/RejectGrantRequest
  (s/keys :req-un [:cognitect.aws.license-manager.RejectGrantRequest/GrantArn]))

(s/def
  :cognitect.aws.license-manager/CreateTokenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateTokenResponse/TokenId
     :cognitect.aws.license-manager.CreateTokenResponse/TokenType
     :cognitect.aws.license-manager.CreateTokenResponse/Token]))

(s/def
  :cognitect.aws.license-manager/InventoryFilter
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.InventoryFilter/Name
     :cognitect.aws.license-manager.InventoryFilter/Condition]
    :opt-un
    [:cognitect.aws.license-manager.InventoryFilter/Value]))

(s/def
  :cognitect.aws.license-manager/GrantedLicense
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.GrantedLicense/ReceivedMetadata
     :cognitect.aws.license-manager.GrantedLicense/Beneficiary
     :cognitect.aws.license-manager.GrantedLicense/Status
     :cognitect.aws.license-manager.GrantedLicense/LicenseMetadata
     :cognitect.aws.license-manager.GrantedLicense/ConsumptionConfiguration
     :cognitect.aws.license-manager.GrantedLicense/ProductSKU
     :cognitect.aws.license-manager.GrantedLicense/LicenseName
     :cognitect.aws.license-manager.GrantedLicense/HomeRegion
     :cognitect.aws.license-manager.GrantedLicense/LicenseArn
     :cognitect.aws.license-manager.GrantedLicense/Issuer
     :cognitect.aws.license-manager.GrantedLicense/ProductName
     :cognitect.aws.license-manager.GrantedLicense/CreateTime
     :cognitect.aws.license-manager.GrantedLicense/Validity
     :cognitect.aws.license-manager.GrantedLicense/Version
     :cognitect.aws.license-manager.GrantedLicense/Entitlements]))

(s/def
  :cognitect.aws.license-manager/FilterLimitExceededException
  (s/keys :opt-un [:cognitect.aws.license-manager.FilterLimitExceededException/Message]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetRulesetArnList
  (s/coll-of :cognitect.aws.license-manager/Arn))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseConfigurationArn]
    :opt-un
    [:cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/ProductInformationList
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/DisassociateWhenNotFound
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseCount
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseExpiry
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/Description
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseCountHardLimit
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseConfigurationStatus
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/Name
     :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseRules]))

(s/def
  :cognitect.aws.license-manager/MatchingRuleStatementList
  (s/coll-of :cognitect.aws.license-manager/MatchingRuleStatement))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupConfiguration
  (s/keys :opt-un [:cognitect.aws.license-manager.LicenseAssetGroupConfiguration/UsageDimension]))

(s/def
  :cognitect.aws.license-manager/ConsumedLicenseSummaryList
  (s/coll-of :cognitect.aws.license-manager/ConsumedLicenseSummary))

(s/def
  :cognitect.aws.license-manager/ProductCodeListItem
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ProductCodeListItem/ProductCodeId
     :cognitect.aws.license-manager.ProductCodeListItem/ProductCodeType]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteLicenseConfigurationRequest/LicenseConfigurationArn]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupConfigurationList
  (s/coll-of :cognitect.aws.license-manager/LicenseAssetGroupConfiguration))

(s/def
  :cognitect.aws.license-manager/ListLicenseConfigurationsForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationResponse/LicenseConfigurations]))

(s/def
  :cognitect.aws.license-manager/ListLicenseManagerReportGeneratorsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsResponse/ReportGenerators]))

(s/def
  :cognitect.aws.license-manager/GetLicenseUsageRequest
  (s/keys :req-un [:cognitect.aws.license-manager.GetLicenseUsageRequest/LicenseArn]))

(s/def
  :cognitect.aws.license-manager/AndRuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.AndRuleStatement/MatchingRuleStatements
     :cognitect.aws.license-manager.AndRuleStatement/ScriptRuleStatements]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.license-manager/ProductInformationFilter
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterName
     :cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterComparator]
    :opt-un
    [:cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterValue]))

(s/def
  :cognitect.aws.license-manager/CreateTokenRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateTokenRequest/LicenseArn
     :cognitect.aws.license-manager.CreateTokenRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateTokenRequest/ExpirationInDays
     :cognitect.aws.license-manager.CreateTokenRequest/RoleArns
     :cognitect.aws.license-manager.CreateTokenRequest/TokenProperties]))

(s/def :cognitect.aws.license-manager/Boolean boolean?)

(s/def
  :cognitect.aws.license-manager/AutomatedDiscoveryInformation
  (s/keys :opt-un [:cognitect.aws.license-manager.AutomatedDiscoveryInformation/LastRunTime]))

(s/def
  :cognitect.aws.license-manager/CheckoutBorrowLicenseResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/IssuedAt
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/EntitlementsAllowed
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/NodeId
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/LicenseConsumptionToken
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/CheckoutMetadata
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/LicenseArn
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/Expiration
     :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/SignedToken]))

(s/def
  :cognitect.aws.license-manager/ServiceStatus
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ServiceStatus/CrossRegionDiscovery
     :cognitect.aws.license-manager.ServiceStatus/CrossAccountDiscovery]))

(s/def
  :cognitect.aws.license-manager/S3Location
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.S3Location/keyPrefix
     :cognitect.aws.license-manager.S3Location/bucket]))

(s/def
  :cognitect.aws.license-manager/ISO8601DateTime
  (s/spec
    #(re-matches
      (re-pattern
        "^(-?(?:[1-9][0-9]*)?[0-9]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][0-9])T(2[0-3]|[0-1][0-9]):([0-5][0-9]):([0-5][0-9])(\\.[0-9]+)?(Z|[+-](?:2[ 0-3]|[0-1][0-9]):[0-5][0-9])+$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupPropertyList
  (s/coll-of :cognitect.aws.license-manager/LicenseAssetGroupProperty))

(s/def
  :cognitect.aws.license-manager/DeleteGrantResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.DeleteGrantResponse/Status
     :cognitect.aws.license-manager.DeleteGrantResponse/GrantArn
     :cognitect.aws.license-manager.DeleteGrantResponse/Version]))

(s/def
  :cognitect.aws.license-manager/TokenString
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.license-manager/InventoryFilterCondition
  (s/spec string? :gen #(s/gen #{"NOT_EQUALS" "CONTAINS" "BEGINS_WITH" "EQUALS"})))

(s/def
  :cognitect.aws.license-manager/Grant
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.Grant/GrantArn
     :cognitect.aws.license-manager.Grant/GrantName
     :cognitect.aws.license-manager.Grant/ParentArn
     :cognitect.aws.license-manager.Grant/LicenseArn
     :cognitect.aws.license-manager.Grant/GranteePrincipalArn
     :cognitect.aws.license-manager.Grant/HomeRegion
     :cognitect.aws.license-manager.Grant/GrantStatus
     :cognitect.aws.license-manager.Grant/Version
     :cognitect.aws.license-manager.Grant/GrantedOperations]
    :opt-un
    [:cognitect.aws.license-manager.Grant/StatusReason
     :cognitect.aws.license-manager.Grant/Options]))

(s/def
  :cognitect.aws.license-manager/ResourceLimitExceededException
  (s/keys :opt-un [:cognitect.aws.license-manager.ResourceLimitExceededException/Message]))

(s/def
  :cognitect.aws.license-manager/ReportFrequencyType
  (s/spec string? :gen #(s/gen #{"WEEK" "MONTH" "ONE_TIME" "DAY"})))

(s/def
  :cognitect.aws.license-manager/LicenseAssetResourceName
  (s/spec
    (s/and string? #(>= 128 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationAssociations
  (s/coll-of :cognitect.aws.license-manager/LicenseConfigurationAssociation))

(s/def
  :cognitect.aws.license-manager/ReportContext
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ReportContext/licenseAssetGroupArns
     :cognitect.aws.license-manager.ReportContext/reportStartDate
     :cognitect.aws.license-manager.ReportContext/reportEndDate
     :cognitect.aws.license-manager.ReportContext/licenseConfigurationArns]))

(s/def
  :cognitect.aws.license-manager/GetLicenseConversionTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseConversionTaskRequest/LicenseConversionTaskId]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseRequest/LicenseName
     :cognitect.aws.license-manager.CreateLicenseRequest/ProductName
     :cognitect.aws.license-manager.CreateLicenseRequest/ProductSKU
     :cognitect.aws.license-manager.CreateLicenseRequest/Issuer
     :cognitect.aws.license-manager.CreateLicenseRequest/HomeRegion
     :cognitect.aws.license-manager.CreateLicenseRequest/Validity
     :cognitect.aws.license-manager.CreateLicenseRequest/Entitlements
     :cognitect.aws.license-manager.CreateLicenseRequest/Beneficiary
     :cognitect.aws.license-manager.CreateLicenseRequest/ConsumptionConfiguration
     :cognitect.aws.license-manager.CreateLicenseRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseRequest/Tags
     :cognitect.aws.license-manager.CreateLicenseRequest/LicenseMetadata]))

(s/def
  :cognitect.aws.license-manager/GetLicenseUsageResponse
  (s/keys :opt-un [:cognitect.aws.license-manager.GetLicenseUsageResponse/LicenseUsage]))

(s/def
  :cognitect.aws.license-manager/ProductInformation
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ProductInformation/ResourceType
     :cognitect.aws.license-manager.ProductInformation/ProductInformationFilterList]))

(s/def
  :cognitect.aws.license-manager/GetGrantResponse
  (s/keys :opt-un [:cognitect.aws.license-manager.GetGrantResponse/Grant]))

(s/def
  :cognitect.aws.license-manager/ReceivedMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ReceivedMetadata/ReceivedStatusReason
     :cognitect.aws.license-manager.ReceivedMetadata/AllowedOperations
     :cognitect.aws.license-manager.ReceivedMetadata/ReceivedStatus]))

(s/def
  :cognitect.aws.license-manager/InstanceRuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.InstanceRuleStatement/ScriptRuleStatement
     :cognitect.aws.license-manager.InstanceRuleStatement/AndRuleStatement
     :cognitect.aws.license-manager.InstanceRuleStatement/OrRuleStatement
     :cognitect.aws.license-manager.InstanceRuleStatement/MatchingRuleStatement]))

(s/def
  :cognitect.aws.license-manager/EntitlementDataUnit
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Terabytes"
        "Kilobits/Second"
        "Count"
        "Bits"
        "Percent"
        "Gigabits/Second"
        "None"
        "Count/Second"
        "Bytes"
        "Gigabytes/Second"
        "Megabits/Second"
        "Kilobytes/Second"
        "Terabytes/Second"
        "Bits/Second"
        "Bytes/Second"
        "Milliseconds"
        "Kilobytes"
        "Microseconds"
        "Terabits"
        "Megabytes/Second"
        "Gigabytes"
        "Gigabits"
        "Megabits"
        "Kilobits"
        "Terabits/Second"
        "Megabytes"
        "Seconds"})))

(s/def
  :cognitect.aws.license-manager/ResourceInventoryList
  (s/coll-of :cognitect.aws.license-manager/ResourceInventory))

(s/def
  :cognitect.aws.license-manager/GetLicenseManagerReportGeneratorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.GetLicenseManagerReportGeneratorResponse/ReportGenerator]))

(s/def
  :cognitect.aws.license-manager/GetLicenseResponse
  (s/keys :opt-un [:cognitect.aws.license-manager.GetLicenseResponse/License]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Name
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCountingType]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseConfigurationRequest/ProductInformationList
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/DisassociateWhenNotFound
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCount
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Tags
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseExpiry
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Description
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCountHardLimit
     :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseRules]))

(s/def
  :cognitect.aws.license-manager/LicenseOperationFailureList
  (s/coll-of :cognitect.aws.license-manager/LicenseOperationFailure))

(s/def
  :cognitect.aws.license-manager/LicenseAssetResourceDescription
  (s/spec
    (s/and string? #(>= 1024 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.license-manager/ReceivedStatus
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DISABLED"
        "PENDING_ACCEPT"
        "WORKFLOW_COMPLETED"
        "FAILED_WORKFLOW"
        "PENDING_WORKFLOW"
        "REJECTED"
        "ACTIVE"
        "DELETED"})))

(s/def
  :cognitect.aws.license-manager/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.license-manager/ListLicensesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicensesRequest/NextToken
     :cognitect.aws.license-manager.ListLicensesRequest/Filters
     :cognitect.aws.license-manager.ListLicensesRequest/LicenseArns
     :cognitect.aws.license-manager.ListLicensesRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/LicenseCountingType
  (s/spec string? :gen #(s/gen #{"Socket" "vCPU" "Core" "Instance"})))

(s/def
  :cognitect.aws.license-manager/ListUsageForLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/LicenseConfigurationArn]
    :opt-un
    [:cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/NextToken
     :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/Filters
     :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/LicenseSpecifications
  (s/coll-of :cognitect.aws.license-manager/LicenseSpecification))

(s/def
  :cognitect.aws.license-manager/ListLicenseSpecificationsForResourceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseSpecificationsForResourceResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceResponse/LicenseSpecifications]))

(s/def :cognitect.aws.license-manager/UpdateLicenseSpecificationsForResourceResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/GetGrantRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetGrantRequest/GrantArn]
    :opt-un
    [:cognitect.aws.license-manager.GetGrantRequest/Version]))

(s/def
  :cognitect.aws.license-manager/RegionStatusMap
  (s/map-of :cognitect.aws.license-manager/String :cognitect.aws.license-manager/RegionStatus))

(s/def
  :cognitect.aws.license-manager/GetServiceSettingsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.GetServiceSettingsResponse/OrganizationConfiguration
     :cognitect.aws.license-manager.GetServiceSettingsResponse/LicenseManagerResourceShareArn
     :cognitect.aws.license-manager.GetServiceSettingsResponse/ServiceStatus
     :cognitect.aws.license-manager.GetServiceSettingsResponse/EnableCrossAccountsDiscovery
     :cognitect.aws.license-manager.GetServiceSettingsResponse/SnsTopicArn
     :cognitect.aws.license-manager.GetServiceSettingsResponse/S3BucketArn
     :cognitect.aws.license-manager.GetServiceSettingsResponse/CrossRegionDiscoveryHomeRegion
     :cognitect.aws.license-manager.GetServiceSettingsResponse/CrossRegionDiscoverySourceRegions]))

(s/def
  :cognitect.aws.license-manager/Asset
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.Asset/LatestAssetDiscoveryTime
     :cognitect.aws.license-manager.Asset/AssetArn]))

(s/def
  :cognitect.aws.license-manager/GetLicenseConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseConfigurationRequest/LicenseConfigurationArn]))

(s/def
  :cognitect.aws.license-manager/ListTokensRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListTokensRequest/TokenIds
     :cognitect.aws.license-manager.ListTokensRequest/NextToken
     :cognitect.aws.license-manager.ListTokensRequest/Filters
     :cognitect.aws.license-manager.ListTokensRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/SignedToken
  (s/spec
    (s/and string? #(<= 4096 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 4096 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.license-manager/CreateLicenseResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseResponse/Status
     :cognitect.aws.license-manager.CreateLicenseResponse/LicenseArn
     :cognitect.aws.license-manager.CreateLicenseResponse/Version]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseConversionTaskForResourceResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceResponse/LicenseConversionTaskId]))

(s/def
  :cognitect.aws.license-manager/LicenseAssetRuleset
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.LicenseAssetRuleset/Name
     :cognitect.aws.license-manager.LicenseAssetRuleset/Rules
     :cognitect.aws.license-manager.LicenseAssetRuleset/LicenseAssetRulesetArn]
    :opt-un
    [:cognitect.aws.license-manager.LicenseAssetRuleset/Description]))

(s/def
  :cognitect.aws.license-manager/MaxSize3StringList
  (s/coll-of :cognitect.aws.license-manager/String :max-count 3))

(s/def
  :cognitect.aws.license-manager/ListLicenseVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListLicenseVersionsRequest/LicenseArn]
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseVersionsRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseVersionsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/ClientRequestToken
  (s/spec
    (s/and string? #(<= 1 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 36) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.license-manager/DeleteLicenseManagerReportGeneratorResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/ListLicenseConfigurationsForOrganizationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/LicenseConfigurationArns
     :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/Filters
     :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.license-manager.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.license-manager/MaxSize100
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.license-manager/GetLicenseAssetGroupResponse
  (s/keys :req-un [:cognitect.aws.license-manager.GetLicenseAssetGroupResponse/LicenseAssetGroup]))

(s/def
  :cognitect.aws.license-manager/LicenseConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConfiguration/ProductInformationList
     :cognitect.aws.license-manager.LicenseConfiguration/DisassociateWhenNotFound
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseCount
     :cognitect.aws.license-manager.LicenseConfiguration/OwnerAccountId
     :cognitect.aws.license-manager.LicenseConfiguration/ManagedResourceSummaryList
     :cognitect.aws.license-manager.LicenseConfiguration/Status
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseExpiry
     :cognitect.aws.license-manager.LicenseConfiguration/ConsumedLicenseSummaryList
     :cognitect.aws.license-manager.LicenseConfiguration/Description
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseCountHardLimit
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseConfigurationArn
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseCountingType
     :cognitect.aws.license-manager.LicenseConfiguration/Name
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseConfigurationId
     :cognitect.aws.license-manager.LicenseConfiguration/AutomatedDiscoveryInformation
     :cognitect.aws.license-manager.LicenseConfiguration/LicenseRules
     :cognitect.aws.license-manager.LicenseConfiguration/ConsumedLicenses]))

(s/def
  :cognitect.aws.license-manager/ResourceInventory
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ResourceInventory/Platform
     :cognitect.aws.license-manager.ResourceInventory/UsageOperation
     :cognitect.aws.license-manager.ResourceInventory/InstanceType
     :cognitect.aws.license-manager.ResourceInventory/HostId
     :cognitect.aws.license-manager.ResourceInventory/MarketplaceProductCodes
     :cognitect.aws.license-manager.ResourceInventory/ResourceId
     :cognitect.aws.license-manager.ResourceInventory/AmiId
     :cognitect.aws.license-manager.ResourceInventory/PlatformVersion
     :cognitect.aws.license-manager.ResourceInventory/ResourceType
     :cognitect.aws.license-manager.ResourceInventory/ResourceOwningAccountId
     :cognitect.aws.license-manager.ResourceInventory/ResourceArn
     :cognitect.aws.license-manager.ResourceInventory/Region]))

(s/def
  :cognitect.aws.license-manager/Metadata
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.Metadata/Value :cognitect.aws.license-manager.Metadata/Name]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.DeleteLicenseResponse/DeletionDate
     :cognitect.aws.license-manager.DeleteLicenseResponse/Status]))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationRuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConfigurationRuleStatement/AndRuleStatement
     :cognitect.aws.license-manager.LicenseConfigurationRuleStatement/OrRuleStatement
     :cognitect.aws.license-manager.LicenseConfigurationRuleStatement/MatchingRuleStatement]))

(s/def
  :cognitect.aws.license-manager/ListLicenseConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConfigurationsRequest/LicenseConfigurationArns
     :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/Filters
     :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/MaxResults]))

(s/def :cognitect.aws.license-manager/TokenType (s/spec string? :gen #(s/gen #{"REFRESH_TOKEN"})))

(s/def
  :cognitect.aws.license-manager/OrganizationConfiguration
  (s/keys :req-un [:cognitect.aws.license-manager.OrganizationConfiguration/EnableIntegration]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseAssetRulesetResponse
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseAssetRulesetResponse/LicenseAssetRulesetArn]))

(s/def
  :cognitect.aws.license-manager/ReportGeneratorList
  (s/coll-of :cognitect.aws.license-manager/ReportGenerator))

(s/def :cognitect.aws.license-manager/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/EntitlementUnit
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Terabytes"
        "Kilobits/Second"
        "Count"
        "Bits"
        "Percent"
        "Gigabits/Second"
        "None"
        "Count/Second"
        "Bytes"
        "Gigabytes/Second"
        "Megabits/Second"
        "Kilobytes/Second"
        "Terabytes/Second"
        "Bits/Second"
        "Bytes/Second"
        "Milliseconds"
        "Kilobytes"
        "Microseconds"
        "Terabits"
        "Megabytes/Second"
        "Gigabytes"
        "Gigabits"
        "Megabits"
        "Kilobits"
        "Terabits/Second"
        "Megabytes"
        "Seconds"})))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseAssetRulesetRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Rules
     :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/LicenseAssetRulesetArn
     :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Description
     :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Name]))

(s/def
  :cognitect.aws.license-manager/TokenList
  (s/coll-of :cognitect.aws.license-manager/TokenData))

(s/def
  :cognitect.aws.license-manager/RejectGrantResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.RejectGrantResponse/Status
     :cognitect.aws.license-manager.RejectGrantResponse/GrantArn
     :cognitect.aws.license-manager.RejectGrantResponse/Version]))

(s/def
  :cognitect.aws.license-manager/RuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.RuleStatement/LicenseRuleStatement
     :cognitect.aws.license-manager.RuleStatement/InstanceRuleStatement
     :cognitect.aws.license-manager.RuleStatement/LicenseConfigurationRuleStatement]))

(s/def
  :cognitect.aws.license-manager/LicenseDeletionStatus
  (s/spec string? :gen #(s/gen #{"PENDING_DELETE" "DELETED"})))

(s/def
  :cognitect.aws.license-manager/ScriptRuleStatementList
  (s/coll-of :cognitect.aws.license-manager/ScriptRuleStatement))

(s/def
  :cognitect.aws.license-manager/LicenseAssetRuleList
  (s/coll-of :cognitect.aws.license-manager/LicenseAssetRule))

(s/def :cognitect.aws.license-manager/FilterList (s/coll-of :cognitect.aws.license-manager/Filter))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteLicenseRequest/LicenseArn
     :cognitect.aws.license-manager.DeleteLicenseRequest/SourceVersion]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseAssetGroupResponse
  (s/keys :req-un [:cognitect.aws.license-manager.DeleteLicenseAssetGroupResponse/Status]))

(s/def
  :cognitect.aws.license-manager/ListLicenseAssetRulesetsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseAssetRulesetsResponse/LicenseAssetRulesets
     :cognitect.aws.license-manager.ListLicenseAssetRulesetsResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/ListLicenseAssetGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseAssetGroupsResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseAssetGroupsResponse/LicenseAssetGroups]))

(s/def
  :cognitect.aws.license-manager/ActivationOverrideBehavior
  (s/spec string? :gen #(s/gen #{"DISTRIBUTED_GRANTS_ONLY" "ALL_GRANTS_PERMITTED_BY_ISSUER"})))

(s/def
  :cognitect.aws.license-manager/DeleteTokenRequest
  (s/keys :req-un [:cognitect.aws.license-manager.DeleteTokenRequest/TokenId]))

(s/def
  :cognitect.aws.license-manager/RateLimitExceededException
  (s/keys :opt-un [:cognitect.aws.license-manager.RateLimitExceededException/Message]))

(s/def
  :cognitect.aws.license-manager/BoxInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.license-manager/CrossRegionDiscoveryStatus
  (s/keys :opt-un [:cognitect.aws.license-manager.CrossRegionDiscoveryStatus/Message]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseManagerReportGeneratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportGeneratorName
     :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Type
     :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportContext
     :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportFrequency
     :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Tags
     :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Description]))

(s/def
  :cognitect.aws.license-manager/ListFailuresForLicenseConfigurationOperationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsResponse/NextToken
     :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsResponse/LicenseOperationFailureList]))

(s/def
  :cognitect.aws.license-manager/LicenseConversionContext
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConversionContext/UsageOperation
     :cognitect.aws.license-manager.LicenseConversionContext/ProductCodes]))

(s/def
  :cognitect.aws.license-manager/RegionStatus
  (s/keys :opt-un [:cognitect.aws.license-manager.RegionStatus/Status]))

(s/def
  :cognitect.aws.license-manager/AllowedOperation
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CheckInLicense"
        "CreateToken"
        "ListPurchasedLicenses"
        "CheckoutBorrowLicense"
        "CheckoutLicense"
        "ExtendConsumptionLicense"
        "CreateGrant"})))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupList
  (s/coll-of :cognitect.aws.license-manager/LicenseAssetGroup))

(s/def
  :cognitect.aws.license-manager/ProductCodeType
  (s/spec string? :gen #(s/gen #{"marketplace"})))

(s/def
  :cognitect.aws.license-manager/MetadataList
  (s/coll-of :cognitect.aws.license-manager/Metadata))

(s/def
  :cognitect.aws.license-manager/ListReceivedLicensesForOrganizationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/NextToken
     :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/Filters
     :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/ReportTypeList
  (s/coll-of :cognitect.aws.license-manager/ReportType))

(s/def
  :cognitect.aws.license-manager/AllowedOperationList
  (s/coll-of :cognitect.aws.license-manager/AllowedOperation :min-count 1 :max-count 8))

(s/def
  :cognitect.aws.license-manager/GetLicenseManagerReportGeneratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn]))

(s/def
  :cognitect.aws.license-manager/CheckoutBorrowLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/LicenseArn
     :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/Entitlements
     :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/DigitalSignatureMethod
     :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/NodeId
     :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/CheckoutMetadata]))

(s/def
  :cognitect.aws.license-manager/InvalidResourceStateException
  (s/keys :opt-un [:cognitect.aws.license-manager.InvalidResourceStateException/Message]))

(s/def
  :cognitect.aws.license-manager/ListLicenseConfigurationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConfigurationsResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseConfigurationsResponse/LicenseConfigurations]))

(s/def
  :cognitect.aws.license-manager/CreateGrantVersionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateGrantVersionResponse/Status
     :cognitect.aws.license-manager.CreateGrantVersionResponse/GrantArn
     :cognitect.aws.license-manager.CreateGrantVersionResponse/Version]))

(s/def
  :cognitect.aws.license-manager/Options
  (s/keys :opt-un [:cognitect.aws.license-manager.Options/ActivationOverrideBehavior]))

(s/def
  :cognitect.aws.license-manager/ReportFrequency
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ReportFrequency/value
     :cognitect.aws.license-manager.ReportFrequency/period]))

(s/def
  :cognitect.aws.license-manager/LicenseConversionTask
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseConversionTask/EndTime
     :cognitect.aws.license-manager.LicenseConversionTask/StartTime
     :cognitect.aws.license-manager.LicenseConversionTask/StatusMessage
     :cognitect.aws.license-manager.LicenseConversionTask/Status
     :cognitect.aws.license-manager.LicenseConversionTask/DestinationLicenseContext
     :cognitect.aws.license-manager.LicenseConversionTask/LicenseConversionTaskId
     :cognitect.aws.license-manager.LicenseConversionTask/SourceLicenseContext
     :cognitect.aws.license-manager.LicenseConversionTask/ResourceArn
     :cognitect.aws.license-manager.LicenseConversionTask/LicenseConversionTime]))

(s/def
  :cognitect.aws.license-manager/DeleteLicenseManagerReportGeneratorRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn]))

(s/def
  :cognitect.aws.license-manager/MatchingRuleStatement
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.MatchingRuleStatement/KeyToMatch
     :cognitect.aws.license-manager.MatchingRuleStatement/Constraint
     :cognitect.aws.license-manager.MatchingRuleStatement/ValueToMatch]))

(s/def
  :cognitect.aws.license-manager/Long
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.license-manager/ListLicensesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicensesResponse/NextToken
     :cognitect.aws.license-manager.ListLicensesResponse/Licenses]))

(s/def
  :cognitect.aws.license-manager/UpdateLicenseAssetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/AssociatedLicenseAssetRulesetARNs
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/LicenseAssetGroupArn
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Status
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Description
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Properties
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Name
     :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/LicenseAssetGroupConfigurations]))

(s/def
  :cognitect.aws.license-manager/Arn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws[a-zA-Z-]*:[A-Za-z0-9][A-Za-z0-9_/.-]{0,62}:[A-Za-z0-9_/.-]{0,63}:[A-Za-z0-9_/.-]{0,63}:[A-Za-z0-9][A-Za-z0-9:_/+=,@.-]{0,1023}$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.license-manager/DeleteLicenseConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/CreateLicenseManagerReportGeneratorResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorResponse/LicenseManagerReportGeneratorArn]))

(s/def
  :cognitect.aws.license-manager/ListReceivedLicensesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedLicensesRequest/NextToken
     :cognitect.aws.license-manager.ListReceivedLicensesRequest/Filters
     :cognitect.aws.license-manager.ListReceivedLicensesRequest/LicenseArns
     :cognitect.aws.license-manager.ListReceivedLicensesRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/AuthorizationException
  (s/keys :opt-un [:cognitect.aws.license-manager.AuthorizationException/Message]))

(s/def
  :cognitect.aws.license-manager/ListUsageForLicenseConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListUsageForLicenseConfigurationResponse/NextToken
     :cognitect.aws.license-manager.ListUsageForLicenseConfigurationResponse/LicenseConfigurationUsageList]))

(s/def
  :cognitect.aws.license-manager/LicenseRuleStatement
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseRuleStatement/AndRuleStatement
     :cognitect.aws.license-manager.LicenseRuleStatement/OrRuleStatement
     :cognitect.aws.license-manager.LicenseRuleStatement/MatchingRuleStatement]))

(s/def
  :cognitect.aws.license-manager/ScriptRuleStatement
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ScriptRuleStatement/KeyToMatch
     :cognitect.aws.license-manager.ScriptRuleStatement/Script]))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationUsageList
  (s/coll-of :cognitect.aws.license-manager/LicenseConfigurationUsage))

(s/def :cognitect.aws.license-manager/GetServiceSettingsRequest (s/keys))

(s/def
  :cognitect.aws.license-manager/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.UntagResourceRequest/ResourceArn
     :cognitect.aws.license-manager.UntagResourceRequest/TagKeys]))

(s/def :cognitect.aws.license-manager/UpdateServiceSettingsResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurations
  (s/coll-of :cognitect.aws.license-manager/LicenseConfiguration))

(s/def
  :cognitect.aws.license-manager/LicenseConfigurationStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "AVAILABLE"})))

(s/def
  :cognitect.aws.license-manager/ManagedResourceSummaryList
  (s/coll-of :cognitect.aws.license-manager/ManagedResourceSummary))

(s/def
  :cognitect.aws.license-manager/LicenseAssetGroupProperty
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.LicenseAssetGroupProperty/Key
     :cognitect.aws.license-manager.LicenseAssetGroupProperty/Value]))

(s/def
  :cognitect.aws.license-manager/LicenseOperationFailure
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.LicenseOperationFailure/OperationName
     :cognitect.aws.license-manager.LicenseOperationFailure/OperationRequestedBy
     :cognitect.aws.license-manager.LicenseOperationFailure/ErrorMessage
     :cognitect.aws.license-manager.LicenseOperationFailure/FailureTime
     :cognitect.aws.license-manager.LicenseOperationFailure/MetadataList
     :cognitect.aws.license-manager.LicenseOperationFailure/ResourceType
     :cognitect.aws.license-manager.LicenseOperationFailure/ResourceArn
     :cognitect.aws.license-manager.LicenseOperationFailure/ResourceOwnerId]))

(s/def
  :cognitect.aws.license-manager/EntitlementData
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.EntitlementData/Name
     :cognitect.aws.license-manager.EntitlementData/Unit]
    :opt-un
    [:cognitect.aws.license-manager.EntitlementData/Value]))

(s/def
  :cognitect.aws.license-manager/ListLicenseConversionTasksRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConversionTasksRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseConversionTasksRequest/Filters
     :cognitect.aws.license-manager.ListLicenseConversionTasksRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/UpdateServiceSettingsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.UpdateServiceSettingsRequest/OrganizationConfiguration
     :cognitect.aws.license-manager.UpdateServiceSettingsRequest/EnabledDiscoverySourceRegions
     :cognitect.aws.license-manager.UpdateServiceSettingsRequest/EnableCrossAccountsDiscovery
     :cognitect.aws.license-manager.UpdateServiceSettingsRequest/SnsTopicArn
     :cognitect.aws.license-manager.UpdateServiceSettingsRequest/S3BucketArn]))

(s/def
  :cognitect.aws.license-manager/CheckoutType
  (s/spec string? :gen #(s/gen #{"PROVISIONAL" "PERPETUAL"})))

(s/def
  :cognitect.aws.license-manager/ClientToken
  (s/spec #(re-matches (re-pattern "\\S+") %) :gen #(gen/string)))

(s/def :cognitect.aws.license-manager/FilterName string?)

(s/def
  :cognitect.aws.license-manager/CrossAccountDiscoveryServiceStatus
  (s/keys :opt-un [:cognitect.aws.license-manager.CrossAccountDiscoveryServiceStatus/Message]))

(s/def :cognitect.aws.license-manager/StringList (s/coll-of :cognitect.aws.license-manager/String))

(s/def
  :cognitect.aws.license-manager/GetLicenseAssetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseAssetGroupRequest/LicenseAssetGroupArn]))

(s/def
  :cognitect.aws.license-manager/ServerInternalException
  (s/keys :opt-un [:cognitect.aws.license-manager.ServerInternalException/Message]))

(s/def
  :cognitect.aws.license-manager/FailedDependencyException
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.FailedDependencyException/ErrorCode
     :cognitect.aws.license-manager.FailedDependencyException/Message]))

(s/def
  :cognitect.aws.license-manager/ListFailuresForLicenseConfigurationOperationsRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/LicenseConfigurationArn]
    :opt-un
    [:cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/NextToken
     :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/GetLicenseConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.GetLicenseConfigurationResponse/ProductInformationList
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/DisassociateWhenNotFound
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCount
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/OwnerAccountId
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ManagedResourceSummaryList
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Tags
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Status
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseExpiry
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ConsumedLicenseSummaryList
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Description
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCountHardLimit
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseConfigurationArn
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCountingType
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Name
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseConfigurationId
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/AutomatedDiscoveryInformation
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseRules
     :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ConsumedLicenses]))

(s/def
  :cognitect.aws.license-manager/GetAccessTokenResponse
  (s/keys :opt-un [:cognitect.aws.license-manager.GetAccessTokenResponse/AccessToken]))

(s/def :cognitect.aws.license-manager/Filters (s/coll-of :cognitect.aws.license-manager/Filter))

(s/def :cognitect.aws.license-manager/AssetList (s/coll-of :cognitect.aws.license-manager/Asset))

(s/def
  :cognitect.aws.license-manager/ListResourceInventoryRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListResourceInventoryRequest/NextToken
     :cognitect.aws.license-manager.ListResourceInventoryRequest/Filters
     :cognitect.aws.license-manager.ListResourceInventoryRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseVersionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseVersionResponse/Status
     :cognitect.aws.license-manager.CreateLicenseVersionResponse/LicenseArn
     :cognitect.aws.license-manager.CreateLicenseVersionResponse/Version]))

(s/def
  :cognitect.aws.license-manager/UnsupportedDigitalSignatureMethodException
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.UnsupportedDigitalSignatureMethodException/Message]))

(s/def
  :cognitect.aws.license-manager/ProductInformationFilterList
  (s/coll-of :cognitect.aws.license-manager/ProductInformationFilter))

(s/def
  :cognitect.aws.license-manager/CreateGrantResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.CreateGrantResponse/Status
     :cognitect.aws.license-manager.CreateGrantResponse/GrantArn
     :cognitect.aws.license-manager.CreateGrantResponse/Version]))

(s/def :cognitect.aws.license-manager/DateTime inst?)

(s/def :cognitect.aws.license-manager/Location string?)

(s/def
  :cognitect.aws.license-manager/ListLicenseAssetRulesetsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/Filters
     :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/ShowAWSManagedLicenseAssetRulesets
     :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/DeleteGrantRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DeleteGrantRequest/GrantArn
     :cognitect.aws.license-manager.DeleteGrantRequest/Version]
    :opt-un
    [:cognitect.aws.license-manager.DeleteGrantRequest/StatusReason]))

(s/def
  :cognitect.aws.license-manager/DatetimeRange
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.DatetimeRange/Begin]
    :opt-un
    [:cognitect.aws.license-manager.DatetimeRange/End]))

(s/def
  :cognitect.aws.license-manager/CheckoutLicenseRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CheckoutLicenseRequest/ProductSKU
     :cognitect.aws.license-manager.CheckoutLicenseRequest/CheckoutType
     :cognitect.aws.license-manager.CheckoutLicenseRequest/KeyFingerprint
     :cognitect.aws.license-manager.CheckoutLicenseRequest/Entitlements
     :cognitect.aws.license-manager.CheckoutLicenseRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CheckoutLicenseRequest/NodeId
     :cognitect.aws.license-manager.CheckoutLicenseRequest/Beneficiary]))

(s/def :cognitect.aws.license-manager/FilterValue string?)

(s/def
  :cognitect.aws.license-manager/License
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.License/Beneficiary
     :cognitect.aws.license-manager.License/Status
     :cognitect.aws.license-manager.License/LicenseMetadata
     :cognitect.aws.license-manager.License/ConsumptionConfiguration
     :cognitect.aws.license-manager.License/ProductSKU
     :cognitect.aws.license-manager.License/LicenseName
     :cognitect.aws.license-manager.License/HomeRegion
     :cognitect.aws.license-manager.License/LicenseArn
     :cognitect.aws.license-manager.License/Issuer
     :cognitect.aws.license-manager.License/ProductName
     :cognitect.aws.license-manager.License/CreateTime
     :cognitect.aws.license-manager.License/Validity
     :cognitect.aws.license-manager.License/Version
     :cognitect.aws.license-manager.License/Entitlements]))

(s/def
  :cognitect.aws.license-manager/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.license-manager.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.license-manager/ListLicenseConversionTasksResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseConversionTasksResponse/NextToken
     :cognitect.aws.license-manager.ListLicenseConversionTasksResponse/LicenseConversionTasks]))

(s/def
  :cognitect.aws.license-manager/UsageOperation
  (s/spec
    (s/and string? #(>= 50 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.license-manager/BoxLong
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.license-manager/ListAssociationsForLicenseConfigurationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationResponse/LicenseConfigurationAssociations
     :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationResponse/NextToken]))

(s/def
  :cognitect.aws.license-manager/LicenseConversionTaskId
  (s/spec #(re-matches (re-pattern "^lct-[a-zA-Z0-9]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.license-manager/ListLicenseManagerReportGeneratorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/Filters
     :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/RenewType
  (s/spec string? :gen #(s/gen #{"Monthly" "None" "Weekly"})))

(s/def
  :cognitect.aws.license-manager/ListLicenseSpecificationsForResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/ResourceArn]
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/EntitlementDataList
  (s/coll-of :cognitect.aws.license-manager/EntitlementData))

(s/def :cognitect.aws.license-manager/String string?)

(s/def
  :cognitect.aws.license-manager/InventoryFilterList
  (s/coll-of :cognitect.aws.license-manager/InventoryFilter))

(s/def :cognitect.aws.license-manager/DeleteTokenResponse (s/keys))

(s/def :cognitect.aws.license-manager/UpdateLicenseConfigurationResponse (s/keys))

(s/def
  :cognitect.aws.license-manager/LicenseList
  (s/coll-of :cognitect.aws.license-manager/License))

(s/def
  :cognitect.aws.license-manager/ListReceivedGrantsForOrganizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/LicenseArn]
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/NextToken
     :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/Filters
     :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/LicenseUsage
  (s/keys :opt-un [:cognitect.aws.license-manager.LicenseUsage/EntitlementUsages]))

(s/def
  :cognitect.aws.license-manager/GetLicenseAssetRulesetResponse
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.GetLicenseAssetRulesetResponse/LicenseAssetRuleset]))

(s/def
  :cognitect.aws.license-manager/BorrowConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.BorrowConfiguration/AllowEarlyCheckIn
     :cognitect.aws.license-manager.BorrowConfiguration/MaxTimeToLiveInMinutes]))

(s/def
  :cognitect.aws.license-manager/ListReceivedGrantsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedGrantsRequest/GrantArns
     :cognitect.aws.license-manager.ListReceivedGrantsRequest/NextToken
     :cognitect.aws.license-manager.ListReceivedGrantsRequest/Filters
     :cognitect.aws.license-manager.ListReceivedGrantsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/DigitalSignatureMethod
  (s/spec string? :gen #(s/gen #{"JWT_PS384"})))

(s/def
  :cognitect.aws.license-manager/InvalidParameterValueException
  (s/keys :opt-un [:cognitect.aws.license-manager.InvalidParameterValueException/Message]))

(s/def
  :cognitect.aws.license-manager/ResourceNotFoundException
  (s/keys :opt-un [:cognitect.aws.license-manager.ResourceNotFoundException/Message]))

(s/def
  :cognitect.aws.license-manager/ConflictException
  (s/keys :opt-un [:cognitect.aws.license-manager.ConflictException/Message]))

(s/def :cognitect.aws.license-manager/TagKeyList (s/coll-of :cognitect.aws.license-manager/String))

(s/def
  :cognitect.aws.license-manager/ListLicenseAssetGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/NextToken
     :cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/Filters
     :cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/MaxResults]))

(s/def
  :cognitect.aws.license-manager/TokenData
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.TokenData/ExpirationTime
     :cognitect.aws.license-manager.TokenData/TokenId
     :cognitect.aws.license-manager.TokenData/TokenType
     :cognitect.aws.license-manager.TokenData/Status
     :cognitect.aws.license-manager.TokenData/LicenseArn
     :cognitect.aws.license-manager.TokenData/RoleArns
     :cognitect.aws.license-manager.TokenData/TokenProperties]))

(s/def
  :cognitect.aws.license-manager/ListReceivedLicensesForOrganizationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.license-manager.ListReceivedLicensesForOrganizationResponse/NextToken
     :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationResponse/Licenses]))

(s/def
  :cognitect.aws.license-manager/CreateLicenseAssetRulesetRequest
  (s/keys
    :req-un
    [:cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Name
     :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Rules
     :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/ClientToken]
    :opt-un
    [:cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Tags
     :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Description]))

(s/def :cognitect.aws.license-manager/DeleteLicenseAssetRulesetResponse (s/keys))

(s/def
  :cognitect.aws.license-manager.GetLicenseAssetRulesetRequest/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ExtendLicenseConsumptionResponse/LicenseConsumptionToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ExtendLicenseConsumptionResponse/Expiration
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.OrRuleStatement/MatchingRuleStatements
  :cognitect.aws.license-manager/MatchingRuleStatementList)

(s/def
  :cognitect.aws.license-manager.OrRuleStatement/ScriptRuleStatements
  :cognitect.aws.license-manager/ScriptRuleStatementList)

(s/def
  :cognitect.aws.license-manager.ExtendLicenseConsumptionRequest/LicenseConsumptionToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ExtendLicenseConsumptionRequest/DryRun
  :cognitect.aws.license-manager/Boolean)

(s/def
  :cognitect.aws.license-manager.TagResourceRequest/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.TagResourceRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/ResourceArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/SourceLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceRequest/DestinationLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseAssetRulesetRequest/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ManagedResourceSummary/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def
  :cognitect.aws.license-manager.ManagedResourceSummary/AssociationCount
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/LicenseAssetGroupArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/AssetType
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/AssociatedLicenseAssetRulesetARNs
  :cognitect.aws.license-manager/LicenseAssetRulesetArnList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/LicenseAssetGroupConfigurations
  :cognitect.aws.license-manager/LicenseAssetGroupConfigurationList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/LatestResourceDiscoveryTime
  :cognitect.aws.license-manager/DateTime)

(s/def :cognitect.aws.license-manager.LicenseAssetGroup/Name :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/StatusMessage
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/LatestUsageAnalysisTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/Properties
  :cognitect.aws.license-manager/LicenseAssetGroupPropertyList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/LicenseAssetGroupArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroup/Status
  :cognitect.aws.license-manager/LicenseAssetGroupStatus)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/Entitlements
  :cognitect.aws.license-manager/EntitlementList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/Issuer
  :cognitect.aws.license-manager/Issuer)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/ConsumptionConfiguration
  :cognitect.aws.license-manager/ConsumptionConfiguration)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/SourceVersion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/HomeRegion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/Validity
  :cognitect.aws.license-manager/DatetimeRange)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/LicenseName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/ProductName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionRequest/Status
  :cognitect.aws.license-manager/LicenseStatus)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesResponse/Licenses
  :cognitect.aws.license-manager/GrantedLicenseList)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/EndTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/LicenseConversionTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/SourceLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/StartTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/StatusMessage
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/DestinationLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/LicenseConversionTaskId
  :cognitect.aws.license-manager/LicenseConversionTaskId)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskResponse/Status
  :cognitect.aws.license-manager/LicenseConversionTaskStatus)

(s/def
  :cognitect.aws.license-manager.GetAccessTokenRequest/Token
  :cognitect.aws.license-manager/TokenString)

(s/def
  :cognitect.aws.license-manager.GetAccessTokenRequest/TokenProperties
  :cognitect.aws.license-manager/MaxSize3StringList)

(s/def
  :cognitect.aws.license-manager.AcceptGrantResponse/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.AcceptGrantResponse/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.AcceptGrantResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceStatus
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/ResourceOwnerId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/AssociationTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationUsage/ConsumedLicenses
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupResponse/Assets
  :cognitect.aws.license-manager/AssetList)

(s/def
  :cognitect.aws.license-manager.ListAssetsForLicenseAssetGroupResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseVersionsResponse/Licenses
  :cognitect.aws.license-manager/LicenseList)

(s/def
  :cognitect.aws.license-manager.ListLicenseVersionsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Tag/Key :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Tag/Value :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationResponse/Grants
  :cognitect.aws.license-manager/GrantList)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsResponse/Grants
  :cognitect.aws.license-manager/GrantList)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/AddLicenseSpecifications
  :cognitect.aws.license-manager/LicenseSpecifications)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseSpecificationsForResourceRequest/RemoveLicenseSpecifications
  :cognitect.aws.license-manager/LicenseSpecifications)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupResponse/LicenseAssetGroupArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupResponse/Status
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetRule/RuleStatement
  :cognitect.aws.license-manager/RuleStatement)

(s/def
  :cognitect.aws.license-manager.LicenseUsageException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.AcceptGrantRequest/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsResponse/Grants
  :cognitect.aws.license-manager/GrantList)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/CheckoutType
  :cognitect.aws.license-manager/CheckoutType)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/LicenseConsumptionToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/EntitlementsAllowed
  :cognitect.aws.license-manager/EntitlementDataList)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/SignedToken
  :cognitect.aws.license-manager/SignedToken)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/NodeId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/IssuedAt
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/Expiration
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseResponse/LicenseArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/GrantName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/AllowedOperations
  :cognitect.aws.license-manager/AllowedOperationList)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/StatusReason
  :cognitect.aws.license-manager/StatusReasonMessage)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/SourceVersion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionRequest/Options
  :cognitect.aws.license-manager/Options)

(s/def :cognitect.aws.license-manager.IssuerDetails/Name :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.IssuerDetails/SignKey :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.IssuerDetails/KeyFingerprint
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ConsumedLicenseSummary/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def
  :cognitect.aws.license-manager.ConsumedLicenseSummary/ConsumedLicenses
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.ProvisionalConfiguration/MaxTimeToLiveInMinutes
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetResponse/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseAssetGroupRequest/LicenseAssetGroupArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.LicenseSpecification/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseSpecification/AmiAssociationScope
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.NoEntitlementsAllowedException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupResponse/LicenseAssetGroupArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupResponse/Status
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.EntitlementUsage/Name :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.EntitlementUsage/ConsumedValue
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.EntitlementUsage/MaxCount
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.EntitlementUsage/Unit
  :cognitect.aws.license-manager/EntitlementDataUnit)

(s/def :cognitect.aws.license-manager.Filter/Name :cognitect.aws.license-manager/FilterName)

(s/def :cognitect.aws.license-manager.Filter/Values :cognitect.aws.license-manager/FilterValues)

(s/def :cognitect.aws.license-manager.Issuer/Name :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Issuer/SignKey :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.GetLicenseRequest/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.RedirectException/Location
  :cognitect.aws.license-manager/Location)

(s/def
  :cognitect.aws.license-manager.RedirectException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ListTokensResponse/Tokens
  :cognitect.aws.license-manager/TokenList)

(s/def
  :cognitect.aws.license-manager.ListTokensResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportGeneratorName
  :cognitect.aws.license-manager/ReportGeneratorName)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/Type
  :cognitect.aws.license-manager/ReportTypeList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportContext
  :cognitect.aws.license-manager/ReportContext)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ReportFrequency
  :cognitect.aws.license-manager/ReportFrequency)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/ClientToken
  :cognitect.aws.license-manager/ClientRequestToken)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseManagerReportGeneratorRequest/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsRequest/GrantArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListDistributedGrantsRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationResponse/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ValidationException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.AccessDeniedException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Name
  :cognitect.aws.license-manager/LicenseAssetResourceName)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Description
  :cognitect.aws.license-manager/LicenseAssetResourceDescription)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/LicenseAssetGroupConfigurations
  :cognitect.aws.license-manager/LicenseAssetGroupConfigurationList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/AssociatedLicenseAssetRulesetARNs
  :cognitect.aws.license-manager/LicenseAssetRulesetArnList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Properties
  :cognitect.aws.license-manager/LicenseAssetGroupPropertyList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetGroupRequest/ClientToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckInLicenseRequest/LicenseConsumptionToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckInLicenseRequest/Beneficiary
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.EntitlementNotAllowedException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/GrantName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/Principals
  :cognitect.aws.license-manager/PrincipalArnList)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/HomeRegion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/AllowedOperations
  :cognitect.aws.license-manager/AllowedOperationList)

(s/def
  :cognitect.aws.license-manager.CreateGrantRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationAssociation/ResourceOwnerId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationAssociation/AssociationTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationAssociation/AmiAssociationScope
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ConsumptionConfiguration/RenewType
  :cognitect.aws.license-manager/RenewType)

(s/def
  :cognitect.aws.license-manager.ConsumptionConfiguration/ProvisionalConfiguration
  :cognitect.aws.license-manager/ProvisionalConfiguration)

(s/def
  :cognitect.aws.license-manager.ConsumptionConfiguration/BorrowConfiguration
  :cognitect.aws.license-manager/BorrowConfiguration)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/ReportGeneratorName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/ReportType
  :cognitect.aws.license-manager/ReportTypeList)

(s/def :cognitect.aws.license-manager.ReportGenerator/Tags :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/S3Location
  :cognitect.aws.license-manager/S3Location)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/LicenseManagerReportGeneratorArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/ReportContext
  :cognitect.aws.license-manager/ReportContext)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/LastReportGenerationTime
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/LastRunFailureReason
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/LastRunStatus
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/ReportFrequency
  :cognitect.aws.license-manager/ReportFrequency)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/CreateTime
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ReportGenerator/ReportCreatorAccount
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListResourceInventoryResponse/ResourceInventoryList
  :cognitect.aws.license-manager/ResourceInventoryList)

(s/def
  :cognitect.aws.license-manager.ListResourceInventoryResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Entitlement/Name :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Entitlement/Value :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Entitlement/MaxCount :cognitect.aws.license-manager/Long)

(s/def :cognitect.aws.license-manager.Entitlement/Overage :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.Entitlement/Unit
  :cognitect.aws.license-manager/EntitlementUnit)

(s/def
  :cognitect.aws.license-manager.Entitlement/AllowCheckIn
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.RejectGrantRequest/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateTokenResponse/TokenId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateTokenResponse/TokenType
  :cognitect.aws.license-manager/TokenType)

(s/def
  :cognitect.aws.license-manager.CreateTokenResponse/Token
  :cognitect.aws.license-manager/TokenString)

(s/def :cognitect.aws.license-manager.InventoryFilter/Name :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.InventoryFilter/Condition
  :cognitect.aws.license-manager/InventoryFilterCondition)

(s/def :cognitect.aws.license-manager.InventoryFilter/Value :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/Entitlements
  :cognitect.aws.license-manager/EntitlementList)

(s/def :cognitect.aws.license-manager.GrantedLicense/LicenseArn :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/Beneficiary
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/Issuer
  :cognitect.aws.license-manager/IssuerDetails)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/ConsumptionConfiguration
  :cognitect.aws.license-manager/ConsumptionConfiguration)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/HomeRegion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/ReceivedMetadata
  :cognitect.aws.license-manager/ReceivedMetadata)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/LicenseMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/Validity
  :cognitect.aws.license-manager/DatetimeRange)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/LicenseName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/CreateTime
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def :cognitect.aws.license-manager.GrantedLicense/Version :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/ProductSKU
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/ProductName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GrantedLicense/Status
  :cognitect.aws.license-manager/LicenseStatus)

(s/def
  :cognitect.aws.license-manager.FilterLimitExceededException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/ProductInformationList
  :cognitect.aws.license-manager/ProductInformationList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseCountHardLimit
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseExpiry
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/Name
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseConfigurationStatus
  :cognitect.aws.license-manager/LicenseConfigurationStatus)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/DisassociateWhenNotFound
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseCount
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseConfigurationRequest/LicenseRules
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroupConfiguration/UsageDimension
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ProductCodeListItem/ProductCodeId
  :cognitect.aws.license-manager/ProductCodeId)

(s/def
  :cognitect.aws.license-manager.ProductCodeListItem/ProductCodeType
  :cognitect.aws.license-manager/ProductCodeType)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseConfigurationRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationResponse/LicenseConfigurations
  :cognitect.aws.license-manager/LicenseConfigurations)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsResponse/ReportGenerators
  :cognitect.aws.license-manager/ReportGeneratorList)

(s/def
  :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseUsageRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.AndRuleStatement/MatchingRuleStatements
  :cognitect.aws.license-manager/MatchingRuleStatementList)

(s/def
  :cognitect.aws.license-manager.AndRuleStatement/ScriptRuleStatements
  :cognitect.aws.license-manager/ScriptRuleStatementList)

(s/def
  :cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterValue
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ProductInformationFilter/ProductInformationFilterComparator
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateTokenRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateTokenRequest/RoleArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.CreateTokenRequest/ExpirationInDays
  :cognitect.aws.license-manager/Integer)

(s/def
  :cognitect.aws.license-manager.CreateTokenRequest/TokenProperties
  :cognitect.aws.license-manager/MaxSize3StringList)

(s/def
  :cognitect.aws.license-manager.CreateTokenRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.AutomatedDiscoveryInformation/LastRunTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/LicenseConsumptionToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/EntitlementsAllowed
  :cognitect.aws.license-manager/EntitlementDataList)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/NodeId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/SignedToken
  :cognitect.aws.license-manager/SignedToken)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/IssuedAt
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/Expiration
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseResponse/CheckoutMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def
  :cognitect.aws.license-manager.ServiceStatus/CrossAccountDiscovery
  :cognitect.aws.license-manager/CrossAccountDiscoveryServiceStatus)

(s/def
  :cognitect.aws.license-manager.ServiceStatus/CrossRegionDiscovery
  :cognitect.aws.license-manager/CrossRegionDiscoveryStatus)

(s/def :cognitect.aws.license-manager.S3Location/bucket :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.S3Location/keyPrefix :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteGrantResponse/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.DeleteGrantResponse/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.DeleteGrantResponse/Version
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Grant/GranteePrincipalArn :cognitect.aws.license-manager/Arn)

(s/def :cognitect.aws.license-manager.Grant/GrantArn :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.Grant/StatusReason
  :cognitect.aws.license-manager/StatusReasonMessage)

(s/def :cognitect.aws.license-manager.Grant/LicenseArn :cognitect.aws.license-manager/Arn)

(s/def :cognitect.aws.license-manager.Grant/GrantStatus :cognitect.aws.license-manager/GrantStatus)

(s/def :cognitect.aws.license-manager.Grant/HomeRegion :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Grant/ParentArn :cognitect.aws.license-manager/Arn)

(s/def :cognitect.aws.license-manager.Grant/GrantName :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Grant/Options :cognitect.aws.license-manager/Options)

(s/def
  :cognitect.aws.license-manager.Grant/GrantedOperations
  :cognitect.aws.license-manager/AllowedOperationList)

(s/def :cognitect.aws.license-manager.Grant/Version :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceLimitExceededException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ReportContext/licenseConfigurationArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ReportContext/licenseAssetGroupArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ReportContext/reportStartDate
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.ReportContext/reportEndDate
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.GetLicenseConversionTaskRequest/LicenseConversionTaskId
  :cognitect.aws.license-manager/LicenseConversionTaskId)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/Entitlements
  :cognitect.aws.license-manager/EntitlementList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/Beneficiary
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/Issuer
  :cognitect.aws.license-manager/Issuer)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/ConsumptionConfiguration
  :cognitect.aws.license-manager/ConsumptionConfiguration)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/HomeRegion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/LicenseMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/Validity
  :cognitect.aws.license-manager/DatetimeRange)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/LicenseName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/ProductSKU
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseRequest/ProductName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseUsageResponse/LicenseUsage
  :cognitect.aws.license-manager/LicenseUsage)

(s/def
  :cognitect.aws.license-manager.ProductInformation/ResourceType
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ProductInformation/ProductInformationFilterList
  :cognitect.aws.license-manager/ProductInformationFilterList)

(s/def :cognitect.aws.license-manager.GetGrantResponse/Grant :cognitect.aws.license-manager/Grant)

(s/def
  :cognitect.aws.license-manager.ReceivedMetadata/ReceivedStatus
  :cognitect.aws.license-manager/ReceivedStatus)

(s/def
  :cognitect.aws.license-manager.ReceivedMetadata/ReceivedStatusReason
  :cognitect.aws.license-manager/StatusReasonMessage)

(s/def
  :cognitect.aws.license-manager.ReceivedMetadata/AllowedOperations
  :cognitect.aws.license-manager/AllowedOperationList)

(s/def
  :cognitect.aws.license-manager.InstanceRuleStatement/AndRuleStatement
  :cognitect.aws.license-manager/AndRuleStatement)

(s/def
  :cognitect.aws.license-manager.InstanceRuleStatement/OrRuleStatement
  :cognitect.aws.license-manager/OrRuleStatement)

(s/def
  :cognitect.aws.license-manager.InstanceRuleStatement/MatchingRuleStatement
  :cognitect.aws.license-manager/MatchingRuleStatement)

(s/def
  :cognitect.aws.license-manager.InstanceRuleStatement/ScriptRuleStatement
  :cognitect.aws.license-manager/ScriptRuleStatement)

(s/def
  :cognitect.aws.license-manager.GetLicenseManagerReportGeneratorResponse/ReportGenerator
  :cognitect.aws.license-manager/ReportGenerator)

(s/def
  :cognitect.aws.license-manager.GetLicenseResponse/License
  :cognitect.aws.license-manager/License)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/ProductInformationList
  :cognitect.aws.license-manager/ProductInformationList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCountHardLimit
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCountingType
  :cognitect.aws.license-manager/LicenseCountingType)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseExpiry
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Name
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/DisassociateWhenNotFound
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseCount
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConfigurationRequest/LicenseRules
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ListLicensesRequest/LicenseArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ListLicensesRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListLicensesRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicensesRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceResponse/LicenseSpecifications
  :cognitect.aws.license-manager/LicenseSpecifications)

(s/def
  :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.GetGrantRequest/GrantArn :cognitect.aws.license-manager/Arn)

(s/def :cognitect.aws.license-manager.GetGrantRequest/Version :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/S3BucketArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/SnsTopicArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/OrganizationConfiguration
  :cognitect.aws.license-manager/OrganizationConfiguration)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/EnableCrossAccountsDiscovery
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/LicenseManagerResourceShareArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/CrossRegionDiscoveryHomeRegion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/CrossRegionDiscoverySourceRegions
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.GetServiceSettingsResponse/ServiceStatus
  :cognitect.aws.license-manager/ServiceStatus)

(s/def :cognitect.aws.license-manager.Asset/AssetArn :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.Asset/LatestAssetDiscoveryTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListTokensRequest/TokenIds
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ListTokensRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListTokensRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListTokensRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.CreateLicenseResponse/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateLicenseResponse/Status
  :cognitect.aws.license-manager/LicenseStatus)

(s/def
  :cognitect.aws.license-manager.CreateLicenseResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseConversionTaskForResourceResponse/LicenseConversionTaskId
  :cognitect.aws.license-manager/LicenseConversionTaskId)

(s/def
  :cognitect.aws.license-manager.LicenseAssetRuleset/Name
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetRuleset/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetRuleset/Rules
  :cognitect.aws.license-manager/LicenseAssetRuleList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetRuleset/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ListLicenseVersionsRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ListLicenseVersionsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseVersionsRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/LicenseConfigurationArns
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsForOrganizationRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseAssetGroupResponse/LicenseAssetGroup
  :cognitect.aws.license-manager/LicenseAssetGroup)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/ConsumedLicenses
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/ProductInformationList
  :cognitect.aws.license-manager/ProductInformationList)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseCountHardLimit
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/ConsumedLicenseSummaryList
  :cognitect.aws.license-manager/ConsumedLicenseSummaryList)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/AutomatedDiscoveryInformation
  :cognitect.aws.license-manager/AutomatedDiscoveryInformation)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseConfigurationId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseCountingType
  :cognitect.aws.license-manager/LicenseCountingType)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseExpiry
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/Name
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/ManagedResourceSummaryList
  :cognitect.aws.license-manager/ManagedResourceSummaryList)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/OwnerAccountId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/DisassociateWhenNotFound
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseCount
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/Status
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConfiguration/LicenseRules
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def :cognitect.aws.license-manager.ResourceInventory/AmiId :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/InstanceType
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/ResourceId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/MarketplaceProductCodes
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/HostId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/PlatformVersion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/Region
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/ResourceOwningAccountId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/Platform
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ResourceInventory/UsageOperation
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Metadata/Name :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.Metadata/Value :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseResponse/Status
  :cognitect.aws.license-manager/LicenseDeletionStatus)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseResponse/DeletionDate
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationRuleStatement/AndRuleStatement
  :cognitect.aws.license-manager/AndRuleStatement)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationRuleStatement/OrRuleStatement
  :cognitect.aws.license-manager/OrRuleStatement)

(s/def
  :cognitect.aws.license-manager.LicenseConfigurationRuleStatement/MatchingRuleStatement
  :cognitect.aws.license-manager/MatchingRuleStatement)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/LicenseConfigurationArns
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.OrganizationConfiguration/EnableIntegration
  :cognitect.aws.license-manager/Boolean)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetResponse/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Name
  :cognitect.aws.license-manager/LicenseAssetResourceName)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Description
  :cognitect.aws.license-manager/LicenseAssetResourceDescription)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/Rules
  :cognitect.aws.license-manager/LicenseAssetRuleList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/LicenseAssetRulesetArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetRulesetRequest/ClientToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.RejectGrantResponse/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.RejectGrantResponse/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.RejectGrantResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.RuleStatement/LicenseConfigurationRuleStatement
  :cognitect.aws.license-manager/LicenseConfigurationRuleStatement)

(s/def
  :cognitect.aws.license-manager.RuleStatement/LicenseRuleStatement
  :cognitect.aws.license-manager/LicenseRuleStatement)

(s/def
  :cognitect.aws.license-manager.RuleStatement/InstanceRuleStatement
  :cognitect.aws.license-manager/InstanceRuleStatement)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseRequest/SourceVersion
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseAssetGroupResponse/Status
  :cognitect.aws.license-manager/LicenseAssetGroupStatus)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsResponse/LicenseAssetRulesets
  :cognitect.aws.license-manager/LicenseAssetRulesetList)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetGroupsResponse/LicenseAssetGroups
  :cognitect.aws.license-manager/LicenseAssetGroupList)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetGroupsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteTokenRequest/TokenId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.RateLimitExceededException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.CrossRegionDiscoveryStatus/Message
  :cognitect.aws.license-manager/RegionStatusMap)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportGeneratorName
  :cognitect.aws.license-manager/ReportGeneratorName)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Type
  :cognitect.aws.license-manager/ReportTypeList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportContext
  :cognitect.aws.license-manager/ReportContext)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ReportFrequency
  :cognitect.aws.license-manager/ReportFrequency)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/ClientToken
  :cognitect.aws.license-manager/ClientRequestToken)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsResponse/LicenseOperationFailureList
  :cognitect.aws.license-manager/LicenseOperationFailureList)

(s/def
  :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConversionContext/UsageOperation
  :cognitect.aws.license-manager/UsageOperation)

(s/def
  :cognitect.aws.license-manager.LicenseConversionContext/ProductCodes
  :cognitect.aws.license-manager/ProductCodeList)

(s/def :cognitect.aws.license-manager.RegionStatus/Status :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.GetLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/Entitlements
  :cognitect.aws.license-manager/EntitlementDataList)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/DigitalSignatureMethod
  :cognitect.aws.license-manager/DigitalSignatureMethod)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/NodeId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/CheckoutMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def
  :cognitect.aws.license-manager.CheckoutBorrowLicenseRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.InvalidResourceStateException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsResponse/LicenseConfigurations
  :cognitect.aws.license-manager/LicenseConfigurations)

(s/def
  :cognitect.aws.license-manager.ListLicenseConfigurationsResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionResponse/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionResponse/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.CreateGrantVersionResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.Options/ActivationOverrideBehavior
  :cognitect.aws.license-manager/ActivationOverrideBehavior)

(s/def :cognitect.aws.license-manager.ReportFrequency/value :cognitect.aws.license-manager/Integer)

(s/def
  :cognitect.aws.license-manager.ReportFrequency/period
  :cognitect.aws.license-manager/ReportFrequencyType)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/EndTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/LicenseConversionTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/SourceLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/StartTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/StatusMessage
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/DestinationLicenseContext
  :cognitect.aws.license-manager/LicenseConversionContext)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/LicenseConversionTaskId
  :cognitect.aws.license-manager/LicenseConversionTaskId)

(s/def
  :cognitect.aws.license-manager.LicenseConversionTask/Status
  :cognitect.aws.license-manager/LicenseConversionTaskStatus)

(s/def
  :cognitect.aws.license-manager.DeleteLicenseManagerReportGeneratorRequest/LicenseManagerReportGeneratorArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.MatchingRuleStatement/KeyToMatch
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.MatchingRuleStatement/Constraint
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.MatchingRuleStatement/ValueToMatch
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.ListLicensesResponse/Licenses
  :cognitect.aws.license-manager/LicenseList)

(s/def
  :cognitect.aws.license-manager.ListLicensesResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Name
  :cognitect.aws.license-manager/LicenseAssetResourceName)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Description
  :cognitect.aws.license-manager/LicenseAssetResourceDescription)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/LicenseAssetGroupConfigurations
  :cognitect.aws.license-manager/LicenseAssetGroupConfigurationList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/AssociatedLicenseAssetRulesetARNs
  :cognitect.aws.license-manager/LicenseAssetRulesetArnList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Properties
  :cognitect.aws.license-manager/LicenseAssetGroupPropertyList)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/LicenseAssetGroupArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/Status
  :cognitect.aws.license-manager/LicenseAssetGroupStatus)

(s/def
  :cognitect.aws.license-manager.UpdateLicenseAssetGroupRequest/ClientToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseManagerReportGeneratorResponse/LicenseManagerReportGeneratorArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesRequest/LicenseArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.AuthorizationException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationResponse/LicenseConfigurationUsageList
  :cognitect.aws.license-manager/LicenseConfigurationUsageList)

(s/def
  :cognitect.aws.license-manager.ListUsageForLicenseConfigurationResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseRuleStatement/AndRuleStatement
  :cognitect.aws.license-manager/AndRuleStatement)

(s/def
  :cognitect.aws.license-manager.LicenseRuleStatement/OrRuleStatement
  :cognitect.aws.license-manager/OrRuleStatement)

(s/def
  :cognitect.aws.license-manager.LicenseRuleStatement/MatchingRuleStatement
  :cognitect.aws.license-manager/MatchingRuleStatement)

(s/def
  :cognitect.aws.license-manager.ScriptRuleStatement/KeyToMatch
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ScriptRuleStatement/Script
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UntagResourceRequest/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UntagResourceRequest/TagKeys
  :cognitect.aws.license-manager/TagKeyList)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroupProperty/Key
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseAssetGroupProperty/Value
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/ResourceType
  :cognitect.aws.license-manager/ResourceType)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/ErrorMessage
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/FailureTime
  :cognitect.aws.license-manager/DateTime)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/OperationName
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/ResourceOwnerId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/OperationRequestedBy
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.LicenseOperationFailure/MetadataList
  :cognitect.aws.license-manager/MetadataList)

(s/def :cognitect.aws.license-manager.EntitlementData/Name :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.EntitlementData/Value :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.EntitlementData/Unit
  :cognitect.aws.license-manager/EntitlementDataUnit)

(s/def
  :cognitect.aws.license-manager.ListLicenseConversionTasksRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseConversionTasksRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseConversionTasksRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.UpdateServiceSettingsRequest/S3BucketArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateServiceSettingsRequest/SnsTopicArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.UpdateServiceSettingsRequest/OrganizationConfiguration
  :cognitect.aws.license-manager/OrganizationConfiguration)

(s/def
  :cognitect.aws.license-manager.UpdateServiceSettingsRequest/EnableCrossAccountsDiscovery
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.UpdateServiceSettingsRequest/EnabledDiscoverySourceRegions
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.CrossAccountDiscoveryServiceStatus/Message
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseAssetGroupRequest/LicenseAssetGroupArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ServerInternalException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.FailedDependencyException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.FailedDependencyException/ErrorCode
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListFailuresForLicenseConfigurationOperationsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseConfigurationArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ConsumedLicenses
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ProductInformationList
  :cognitect.aws.license-manager/ProductInformationList)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCountHardLimit
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ConsumedLicenseSummaryList
  :cognitect.aws.license-manager/ConsumedLicenseSummaryList)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/AutomatedDiscoveryInformation
  :cognitect.aws.license-manager/AutomatedDiscoveryInformation)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseConfigurationId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCountingType
  :cognitect.aws.license-manager/LicenseCountingType)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseExpiry
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Name
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/ManagedResourceSummaryList
  :cognitect.aws.license-manager/ManagedResourceSummaryList)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/OwnerAccountId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Description
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/DisassociateWhenNotFound
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseCount
  :cognitect.aws.license-manager/BoxLong)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/Status
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.GetLicenseConfigurationResponse/LicenseRules
  :cognitect.aws.license-manager/StringList)

(s/def
  :cognitect.aws.license-manager.GetAccessTokenResponse/AccessToken
  :cognitect.aws.license-manager/TokenString)

(s/def
  :cognitect.aws.license-manager.ListResourceInventoryRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListResourceInventoryRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListResourceInventoryRequest/Filters
  :cognitect.aws.license-manager/InventoryFilterList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionResponse/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseVersionResponse/Status
  :cognitect.aws.license-manager/LicenseStatus)

(s/def
  :cognitect.aws.license-manager.UnsupportedDigitalSignatureMethodException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.CreateGrantResponse/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.CreateGrantResponse/Status
  :cognitect.aws.license-manager/GrantStatus)

(s/def
  :cognitect.aws.license-manager.CreateGrantResponse/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/ShowAWSManagedLicenseAssetRulesets
  :cognitect.aws.license-manager/Boolean)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetRulesetsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DeleteGrantRequest/GrantArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.DeleteGrantRequest/StatusReason
  :cognitect.aws.license-manager/StatusReasonMessage)

(s/def
  :cognitect.aws.license-manager.DeleteGrantRequest/Version
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.DatetimeRange/Begin
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.DatetimeRange/End
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/ProductSKU
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/CheckoutType
  :cognitect.aws.license-manager/CheckoutType)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/KeyFingerprint
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/Entitlements
  :cognitect.aws.license-manager/EntitlementDataList)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/ClientToken
  :cognitect.aws.license-manager/ClientToken)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/Beneficiary
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CheckoutLicenseRequest/NodeId
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.License/Entitlements
  :cognitect.aws.license-manager/EntitlementList)

(s/def :cognitect.aws.license-manager.License/LicenseArn :cognitect.aws.license-manager/Arn)

(s/def :cognitect.aws.license-manager.License/Beneficiary :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.License/Issuer :cognitect.aws.license-manager/IssuerDetails)

(s/def
  :cognitect.aws.license-manager.License/ConsumptionConfiguration
  :cognitect.aws.license-manager/ConsumptionConfiguration)

(s/def :cognitect.aws.license-manager.License/HomeRegion :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.License/LicenseMetadata
  :cognitect.aws.license-manager/MetadataList)

(s/def :cognitect.aws.license-manager.License/Validity :cognitect.aws.license-manager/DatetimeRange)

(s/def :cognitect.aws.license-manager.License/LicenseName :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.License/CreateTime
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def :cognitect.aws.license-manager.License/Version :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.License/ProductSKU :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.License/ProductName :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.License/Status :cognitect.aws.license-manager/LicenseStatus)

(s/def
  :cognitect.aws.license-manager.ListTagsForResourceResponse/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.ListLicenseConversionTasksResponse/LicenseConversionTasks
  :cognitect.aws.license-manager/LicenseConversionTasks)

(s/def
  :cognitect.aws.license-manager.ListLicenseConversionTasksResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationResponse/LicenseConfigurationAssociations
  :cognitect.aws.license-manager/LicenseConfigurationAssociations)

(s/def
  :cognitect.aws.license-manager.ListAssociationsForLicenseConfigurationResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseManagerReportGeneratorsRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/ResourceArn
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseSpecificationsForResourceRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/LicenseArn
  :cognitect.aws.license-manager/Arn)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsForOrganizationRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.LicenseUsage/EntitlementUsages
  :cognitect.aws.license-manager/EntitlementUsageList)

(s/def
  :cognitect.aws.license-manager.GetLicenseAssetRulesetResponse/LicenseAssetRuleset
  :cognitect.aws.license-manager/LicenseAssetRuleset)

(s/def
  :cognitect.aws.license-manager.BorrowConfiguration/AllowEarlyCheckIn
  :cognitect.aws.license-manager/BoxBoolean)

(s/def
  :cognitect.aws.license-manager.BorrowConfiguration/MaxTimeToLiveInMinutes
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsRequest/GrantArns
  :cognitect.aws.license-manager/ArnList)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsRequest/Filters
  :cognitect.aws.license-manager/FilterList)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedGrantsRequest/MaxResults
  :cognitect.aws.license-manager/MaxSize100)

(s/def
  :cognitect.aws.license-manager.InvalidParameterValueException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ResourceNotFoundException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ConflictException/Message
  :cognitect.aws.license-manager/Message)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/Filters
  :cognitect.aws.license-manager/Filters)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/MaxResults
  :cognitect.aws.license-manager/BoxInteger)

(s/def
  :cognitect.aws.license-manager.ListLicenseAssetGroupsRequest/NextToken
  :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.TokenData/TokenId :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.TokenData/TokenType :cognitect.aws.license-manager/String)

(s/def :cognitect.aws.license-manager.TokenData/LicenseArn :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.TokenData/ExpirationTime
  :cognitect.aws.license-manager/ISO8601DateTime)

(s/def
  :cognitect.aws.license-manager.TokenData/TokenProperties
  :cognitect.aws.license-manager/MaxSize3StringList)

(s/def :cognitect.aws.license-manager.TokenData/RoleArns :cognitect.aws.license-manager/ArnList)

(s/def :cognitect.aws.license-manager.TokenData/Status :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationResponse/Licenses
  :cognitect.aws.license-manager/GrantedLicenseList)

(s/def
  :cognitect.aws.license-manager.ListReceivedLicensesForOrganizationResponse/NextToken
  :cognitect.aws.license-manager/String)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Name
  :cognitect.aws.license-manager/LicenseAssetResourceName)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Description
  :cognitect.aws.license-manager/LicenseAssetResourceDescription)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Rules
  :cognitect.aws.license-manager/LicenseAssetRuleList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/Tags
  :cognitect.aws.license-manager/TagList)

(s/def
  :cognitect.aws.license-manager.CreateLicenseAssetRulesetRequest/ClientToken
  :cognitect.aws.license-manager/String)

