(ns codescene.features.reports.emails.template
  (:require
   [codescene.features.reports.common.styling :as styling]
   [selmer.parser :as parser]))


(defn format-code-health-body
  "
  Renders an HTML file from a template, using the params:
  - is-cloud true/false
  - project-name - name of the project
  - report-generated-on - a tick instant
  - dashboard-link - should lead to this specific project's dashboard
  - unsubscribe-link - link to unsubscribe if available, only used if is-cloud = true
  "
  [params]
  (let [updated-params (update params :report-generated-on styling/instant->printable-string-with-time)]
    (parser/render-file "templates/reports/emails/report-code-health.html" updated-params)))

(comment
 (spit "reports/codehealth-onprem.html"
       (format-code-health-body
        {:is-cloud false
         :project-name "My project"
         :report-generated-on (tick.core/now)
         :dashboard-link "http://bar.foo"
         :unsubscribe-link "http://foo.bar"}))
 )


(defn format-portfolio-body
  "
   Renders an HTML file from a template, using the params:
   - is-cloud - true/false
   - account-name - Only used if is-cloud = true.
                    If it is a private account, it would just be the Account user name. If organization, Organization name.
   - is-private - true/false, indicates if it is private account
   - report-generated-on - a tick instant
   - projects-link - link to the projects page
   - unubscribe-link - link to unsubscribe if available, only used if is-cloud = true
   "
  [params]
  (let [updated-params (update params :report-generated-on styling/instant->printable-string-with-time)]
    (parser/render-file "templates/reports/emails/report-software-portfolio.html" updated-params)))

(comment
 (spit "target/portfolio-cloud-private.html"
       (format-portfolio-body
        {:is-cloud true
         :account-name "Ulrika Wiss"
         :is-private true
         :report-generated-on (tick.core/now)
         :projects-link "http://bar.foo"
         :unsubscribe-link "http://foo.bar"}))
 )


(defn format-legacy-body
  "
  Renders a text string for email body, using the params:
  - detail-url - URL to a more detailed page
  - unsubscribe-url - URL to unsubscribe if available
  "
  [{:keys [detail-url unsubscribe-url]}]
  (if unsubscribe-url
    (format
     (str "This is an auto-generated report from CodeScene."
          "<br/>Check out the full interactive CodeScene analysis results <a href=\"%s\">here</a>.
          <br/><br/>Unsubscribe from the report <a href=\"%s\">here</a>.")
     detail-url
     unsubscribe-url)
    (format
     (str "This is an auto-generated report from CodeScene."
          "<br/>Check out the full interactive CodeScene analysis results "
          "<a href=\"%s\">here</a>.")
     detail-url)))

