(ns codescene.features.pm-data.specs
  (:require [clojure.spec.alpha :as s]
            [codescene.specs :as specs]))

(s/def ::type #{"azure" "github" "shortcut" "jira" "trello" "youtrack" "gitlab" "clickup"})
(s/def ::api-url string?)
(s/def ::organization string?)
(s/def ::name string?)
(s/def ::username string?)
(s/def ::password (s/nilable string?))
(s/def ::external-project-ids (s/coll-of ::specs/non-empty-string))
(s/def ::cost-field string?)
(s/def ::work-in-progress-transition-names (s/coll-of ::specs/non-empty-string))
(s/def ::work-done-transition-names (s/coll-of ::specs/non-empty-string))
(s/def ::supported-work-types (s/coll-of ::specs/non-empty-string))
(s/def ::defect-and-failure-labels (s/coll-of ::specs/non-empty-string))
(s/def ::rename-work-types (s/coll-of (s/tuple ::specs/non-empty-string ::specs/non-empty-string)))
(s/def ::project-aliases (s/coll-of (s/tuple ::specs/non-empty-string ::specs/non-empty-string)))
(s/def ::map-subtasks-to-parent-issues boolean?)
(s/def ::map-commits-to-pull-request-issues boolean?)
(s/def ::use-labels-as-work-types boolean?)
(s/def ::uses-supported-work-types boolean?)
(s/def ::uses-done-transitions boolean?)
(s/def ::configuration-data map?)

(s/def ::provider-def
  (s/keys :req-un [::type]
          :opt-un [::name ::username ::password ::api-url]))
(s/def ::repo-urls (s/coll-of string? ::distinct true))
(s/def ::pm-data-context (s/keys :req-un [::repo-urls]))
