(ns codescene.features.pm-data.pm-data-provider
  "Multimethods for creating pm data provider implementations."
  (:require [clojure.spec.alpha :as s]
            [codescene.features.pm-data.pm-data-configuration :refer [PmDataConfiguration]]
            [codescene.pm-data.pm-data-provider :refer [PmDataProvider]]
            [codescene.features.pm-data.specs :as pm-specs]))

(defmulti -create-pm-data-provider (fn [provider-def _pm-data-context] (:type provider-def)))
(defmulti -uses-supported-work-types (fn [provider-def] (:type provider-def)))
(defmulti -uses-done-transitions (fn [provider-def] (:type provider-def)))

(defmethod -uses-supported-work-types :default [_provider-def]
  true)

(defmethod -uses-done-transitions :default [_provider-def]
  true)

(s/def ::pm-data-provider #(and (satisfies? PmDataConfiguration %)
                                (satisfies? PmDataProvider %)))

(s/fdef create-pm-data-provider
  :args (s/cat :provider-def ::pm-specs/provider-def
               :pm-data-context ::pm-specs/pm-data-context)
  :ret ::pm-data-provider)

(defn create-pm-data-provider
  "Create a provider according to the def"
  [provider-def pm-data-context]
  (-create-pm-data-provider provider-def pm-data-context))

(s/fdef uses-supported-work-types
  :args (s/cat :provider-def ::pm-specs/provider-def)
  :ret boolean?)

(defn uses-supported-work-types
  [provider-def]
  (-uses-supported-work-types provider-def))

(s/fdef uses-done-transitions
  :args (s/cat :provider-def ::pm-specs/provider-def)
  :ret boolean?)

(defn uses-done-transitions
  [provider-def]
  (-uses-done-transitions provider-def))
