(ns codescene.features.pm-data.pm-data-configuration
  "Multimethods for creating pm data provider implementations."
  (:require [clojure.spec.alpha :as s]
            [codescene.features.pm-data.specs :as pm-specs]))

(defprotocol PmDataConfiguration
  (-get-configuration-data [this])
  (-validate-settings [this]))

(s/def ::pm-data-configuration #(satisfies? PmDataConfiguration %))

(s/fdef get-configuration-data
  :args (s/cat :provider ::pm-data-configuration)
  :ret ::pm-specs/configuration-data)

(defn get-configuration-data
  "Get data (projects, work-types, transitions, ...) used for configuring the provider."
  [this]
  (-get-configuration-data this))

(s/fdef validate-settings
  :args (s/cat :provider ::pm-data-configuration)
  :ret any?)

(defn validate-settings
  [this]
  (-validate-settings this))
