(ns codescene.features.pm-data.bitbucket-server.fetcher
  "Uses the BitBucket Server API for fetching data.
   This includes combining and transforming data to internal pm-data format, and in some cases catching and reporting errors."
  (:require [taoensso.timbre :as log]
            [codescene.features.repository-provider.bitbucket-server.api :as api]
            [evolutionary-metrics.trends.dates :as dates]))

(defn- pr->result [authed-client repo-info {:keys [description title id fromRef updatedDate] :as _pr}]
  {:id (str id)
   :title title
   :branch (-> fromRef :displayId)
   :text description
   ;:merge-commit nil ;; Not in pr payload!?
   :commits (api/get-commit-ids authed-client repo-info id)
   :updated (dates/timestamp->date updatedDate)})

(defn fetch-pull-requests
  "Fetches pull-requests from the remote BitBucket Server API. Throws when the API calls fail."
  [since api-client repo-info]
  (log/infof "Fetch pull requests from BitBucket Server since %s" (or since "-"))
  (let [search-options {:since since}]
    (->> (api/get-all-pull-requests api-client repo-info search-options)
         (mapv (partial pr->result api-client repo-info)))))

(comment
  (def api-client (codescene.features.client.api/->ExtraProperties
                   {:api-url "http://localhost:7990/rest/api/1.0"}
                   (System/getenv "BITBUCKET_SERVER_TOKEN")))
  (def repo-info (codescene.url.url-utils/repo-url->repo-info  "ssh://git@localhost:7999/te/analysis-target.git" :bitbucket false))
  (fetch-pull-requests "2022-07-04T07:02:27Z" api-client repo-info)
  )
