// @flow
import $ from 'jquery';
import d3 from 'd3';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import * as complexityTrends from 'codescene-ui/src/analyses/complexity-trends';

const parseDate = d3.time.format('%Y-%m-%d').parse;

export function parseRow(row : any) {
  return {
    comments: parseInt(row.comments),
    date: parseDate(row.date),
    n: parseInt(row.n),
    total: parseFloat(row.total),
    ratio: parseFloat(row.ratio),
    dateString: row.date
  };
}

type ViewOptions = {
  systemComplexityUrl : string
};
export function init(options : ViewOptions) {
  const body = $('.complexity-trend-view');
  xhr.csv(options.systemComplexityUrl, parseRow)
    .then(data => {
      if (data === undefined || data.length == 0) {
        const trendContainer = $('.content');
        alerts.warning(trendContainer, '<strong>This analysis is disabled.</strong> You need to enable the Architectural Trends analysis in your project configuration and run a new analysis.'); 
      } else {
        complexityTrends.drawComplexityTrend($('#trendline'), data);

        const growthRatio = $('#growthratio');
        complexityTrends.drawRatioTrend(growthRatio, data);
      }
    })
    .catch(err => {
      console.error(err);
      alerts.error(body, 'Failed to get system complexity data.');
    });
}
