// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as fractals from 'codescene-ui/src/analyses/fractals';

function toFractal(d) {
  return {
    entity: d.entity,
    owner: d.author,
    ownership: parseFloat(d.ownership),
    w: parseFloat(d.w),
    h: parseFloat(d.h),
    x: parseFloat(d.x),
    y: parseFloat(d.y)
  };
}

export function showFragmentationModal(fractalSourceName : string, projectId : number, analysisId : number, fileName : string, knownAuthorColors : Object) {
  const data = xhr.csv(`${window.baseUrl}${projectId}/analyses/${analysisId}/${fractalSourceName}`)
    .then(fractals => fractals.filter(f => f.entity === fileName))
    .then(f => f.map(toFractal));

  fractals.showFragmentationModal(data, 'Fragmentation', $('<span class="filename">').text(fileName), knownAuthorColors);
}
