// Compiled by ClojureScript 1.11.4 {:optimizations :none}
goog.provide('same.diff');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('same.ish');
goog.require('same.platform');
/**
 * If `a` is an array, convert to a vector so it prints nicely.
 */
same.diff.un_array = (function same$diff$un_array(a){
if(same.platform.is_array_QMARK_.call(null,a)){
return cljs.core.vec.call(null,a);
} else {
return a;
}
});
same.diff.result_vec = (function same$diff$result_vec(var_args){
var args__4870__auto__ = [];
var len__4864__auto___9796 = arguments.length;
var i__4865__auto___9797 = (0);
while(true){
if((i__4865__auto___9797 < len__4864__auto___9796)){
args__4870__auto__.push((arguments[i__4865__auto___9797]));

var G__9798 = (i__4865__auto___9797 + (1));
i__4865__auto___9797 = G__9798;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return same.diff.result_vec.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(same.diff.result_vec.cljs$core$IFn$_invoke$arity$variadic = (function (n,res,next){
if(cljs.core.empty_QMARK_.call(null,next)){
return res;
} else {
return cljs.core.into.call(null,cljs.core.into.call(null,(function (){var or__4253__auto__ = res;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.take.call(null,(n - cljs.core.count.call(null,res)),cljs.core.repeat.call(null,null))),next);
}
}));

(same.diff.result_vec.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(same.diff.result_vec.cljs$lang$applyTo = (function (seq9793){
var G__9794 = cljs.core.first.call(null,seq9793);
var seq9793__$1 = cljs.core.next.call(null,seq9793);
var G__9795 = cljs.core.first.call(null,seq9793__$1);
var seq9793__$2 = cljs.core.next.call(null,seq9793__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9794,G__9795,seq9793__$2);
}));


/**
 * Protocol for generating diffs of any type.
 * @interface
 */
same.diff.Diff = function(){};

var same$diff$Diff$diff$dyn_9799 = (function (this$,that){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (same.diff.diff[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,this$,that);
} else {
var m__4549__auto__ = (same.diff.diff["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,this$,that);
} else {
throw cljs.core.missing_protocol.call(null,"Diff.diff",this$);
}
}
});
/**
 * Returns the diff of two values, in the same format as `clojure.data/diff`,
 *  i.e. a vector of 3 elements: `[parts-only-in-this parts-only-in-that parts-in-both]`
 */
same.diff.diff = (function same$diff$diff(this$,that){
if((((!((this$ == null)))) && ((!((this$.same$diff$Diff$diff$arity$2 == null)))))){
return this$.same$diff$Diff$diff$arity$2(this$,that);
} else {
return same$diff$Diff$diff$dyn_9799.call(null,this$,that);
}
});

/**
 * Diff of sequential types, by comparing element-wise.
 */
same.diff.diff_seq = (function same$diff$diff_seq(this$,that){
var l = null;
var r = null;
var c = null;
var n = (0);
var left = this$;
var right = that;
while(true){
if(((cljs.core.empty_QMARK_.call(null,left)) || (cljs.core.empty_QMARK_.call(null,right)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,same.diff.result_vec,n,l,left),cljs.core.apply.call(null,same.diff.result_vec,n,r,right),c], null);
} else {
var vec__9809 = left;
var seq__9810 = cljs.core.seq.call(null,vec__9809);
var first__9811 = cljs.core.first.call(null,seq__9810);
var seq__9810__$1 = cljs.core.next.call(null,seq__9810);
var l0 = first__9811;
var lm = seq__9810__$1;
var vec__9812 = right;
var seq__9813 = cljs.core.seq.call(null,vec__9812);
var first__9814 = cljs.core.first.call(null,seq__9813);
var seq__9813__$1 = cljs.core.next.call(null,seq__9813);
var r0 = first__9814;
var rm = seq__9813__$1;
if(cljs.core.truth_(same.ish.ish.call(null,l0,r0))){
var G__9818 = l;
var G__9819 = r;
var G__9820 = same.diff.result_vec.call(null,n,c,r0);
var G__9821 = (n + (1));
var G__9822 = lm;
var G__9823 = rm;
l = G__9818;
r = G__9819;
c = G__9820;
n = G__9821;
left = G__9822;
right = G__9823;
continue;
} else {
var vec__9815 = same.diff.diff.call(null,l0,r0);
var dl = cljs.core.nth.call(null,vec__9815,(0),null);
var dr = cljs.core.nth.call(null,vec__9815,(1),null);
var dc = cljs.core.nth.call(null,vec__9815,(2),null);
var G__9824 = same.diff.result_vec.call(null,n,l,dl);
var G__9825 = same.diff.result_vec.call(null,n,r,dr);
var G__9826 = (((dc == null))?c:same.diff.result_vec.call(null,n,c,dc));
var G__9827 = (n + (1));
var G__9828 = lm;
var G__9829 = rm;
l = G__9824;
r = G__9825;
c = G__9826;
n = G__9827;
left = G__9828;
right = G__9829;
continue;
}
}
break;
}
});
same.diff.update_common_keys = (function same$diff$update_common_keys(acc,lmap,rmap,keys){
return cljs.core.reduce.call(null,(function (m,k){
var vec__9830 = same.diff.diff.call(null,cljs.core.get.call(null,lmap,k),cljs.core.get.call(null,rmap,k));
var dl = cljs.core.nth.call(null,vec__9830,(0),null);
var dr = cljs.core.nth.call(null,vec__9830,(1),null);
var dc = cljs.core.nth.call(null,vec__9830,(2),null);
var G__9833 = m;
var G__9833__$1 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__9833,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),k], null),dl):G__9833);
var G__9833__$2 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__9833__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),k], null),dr):G__9833__$1);
if((!((dc == null)))){
return cljs.core.assoc_in.call(null,G__9833__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),k], null),dc);
} else {
return G__9833__$2;
}
}),acc,keys);
});
same.diff.update_float_keys = (function same$diff$update_float_keys(acc,lmap,rmap,lkeys,rkeys){
var a = acc;
var lk = lkeys;
var rk = rkeys;
while(true){
if(((cljs.core.empty_QMARK_.call(null,lk)) && (cljs.core.empty_QMARK_.call(null,rk)))){
return a;
} else {
if(cljs.core.empty_QMARK_.call(null,lk)){
return cljs.core.reduce.call(null,((function (a,lk,rk){
return (function (p1__9834_SHARP_,p2__9835_SHARP_){
return cljs.core.assoc_in.call(null,p1__9834_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),p2__9835_SHARP_], null),cljs.core.get.call(null,rmap,p2__9835_SHARP_));
});})(a,lk,rk))
,a,rk);
} else {
if(cljs.core.empty_QMARK_.call(null,rk)){
return cljs.core.reduce.call(null,((function (a,lk,rk){
return (function (p1__9836_SHARP_,p2__9837_SHARP_){
return cljs.core.assoc_in.call(null,p1__9836_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),p2__9837_SHARP_], null),cljs.core.get.call(null,lmap,p2__9837_SHARP_));
});})(a,lk,rk))
,a,lk);
} else {
var vec__9838 = lk;
var seq__9839 = cljs.core.seq.call(null,vec__9838);
var first__9840 = cljs.core.first.call(null,seq__9839);
var seq__9839__$1 = cljs.core.next.call(null,seq__9839);
var lk0 = first__9840;
var lkr = seq__9839__$1;
var vec__9841 = rk;
var seq__9842 = cljs.core.seq.call(null,vec__9841);
var first__9843 = cljs.core.first.call(null,seq__9842);
var seq__9842__$1 = cljs.core.next.call(null,seq__9842);
var rk0 = first__9843;
var rkr = seq__9842__$1;
var lv = cljs.core.get.call(null,lmap,lk0);
var rv = cljs.core.get.call(null,rmap,rk0);
if(cljs.core.truth_(same.ish.ish.call(null,lk0,rk0))){
var vec__9844 = same.diff.diff.call(null,lv,rv);
var dl = cljs.core.nth.call(null,vec__9844,(0),null);
var dr = cljs.core.nth.call(null,vec__9844,(1),null);
var dc = cljs.core.nth.call(null,vec__9844,(2),null);
var acc__$1 = (function (){var G__9847 = a;
var G__9847__$1 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__9847,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),lk0], null),dl):G__9847);
var G__9847__$2 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__9847__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),rk0], null),dr):G__9847__$1);
if((!((dc == null)))){
return cljs.core.assoc_in.call(null,G__9847__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),rk0], null),dc);
} else {
return G__9847__$2;
}
})();
var G__9848 = acc__$1;
var G__9849 = lkr;
var G__9850 = rkr;
a = G__9848;
lk = G__9849;
rk = G__9850;
continue;
} else {
if((lk0 < rk0)){
var G__9851 = cljs.core.assoc_in.call(null,a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),lk0], null),lv);
var G__9852 = lkr;
var G__9853 = rk;
a = G__9851;
lk = G__9852;
rk = G__9853;
continue;
} else {
var G__9854 = cljs.core.assoc_in.call(null,a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),rk0], null),rv);
var G__9855 = lk;
var G__9856 = rkr;
a = G__9854;
lk = G__9855;
rk = G__9856;
continue;

}
}

}
}
}
break;
}
});
(same.diff.Diff["null"] = true);

(same.diff.diff["null"] = (function (_this,that){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,that,null], null);
}));

(same.diff.Diff["number"] = true);

(same.diff.diff["number"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["boolean"] = true);

(same.diff.diff["boolean"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["string"] = true);

(same.diff.diff["string"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["array"] = true);

(same.diff.diff["array"] = (function (this$,that){
if(same.platform.is_array_QMARK_.call(null,that)){
return same.diff.diff_seq.call(null,this$,that);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [same.diff.un_array.call(null,this$),that,null], null);
}
}));

(same.diff.Diff["object"] = true);

(same.diff.diff["object"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,same.diff.un_array.call(null,that)], null);
} else {
if(((cljs.core.sequential_QMARK_.call(null,this$)) && (cljs.core.sequential_QMARK_.call(null,that)))){
return same.diff.diff_seq.call(null,this$,that);
} else {
if(((cljs.core.map_QMARK_.call(null,this$)) && (cljs.core.map_QMARK_.call(null,that)))){
var vec__9857 = same.ish.split_floats.call(null,cljs.core.keys.call(null,this$));
var this_floats = cljs.core.nth.call(null,vec__9857,(0),null);
var this_rest = cljs.core.nth.call(null,vec__9857,(1),null);
var vec__9860 = same.ish.split_floats.call(null,cljs.core.keys.call(null,that));
var that_floats = cljs.core.nth.call(null,vec__9860,(0),null);
var that_rest = cljs.core.nth.call(null,vec__9860,(1),null);
var extract = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"l","l",1395893423),new cljs.core.Keyword(null,"r","r",-471384190),new cljs.core.Keyword(null,"c","c",-1763192079));
return cljs.core.mapv.call(null,cljs.core.not_empty,extract.call(null,same.diff.update_float_keys.call(null,same.diff.update_common_keys.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"l","l",1395893423),cljs.core.select_keys.call(null,this$,clojure.set.difference.call(null,this_rest,that_rest)),new cljs.core.Keyword(null,"r","r",-471384190),cljs.core.select_keys.call(null,that,clojure.set.difference.call(null,that_rest,this_rest)),new cljs.core.Keyword(null,"c","c",-1763192079),cljs.core.PersistentArrayMap.EMPTY], null),this$,that,clojure.set.intersection.call(null,this_rest,that_rest)),this$,that,cljs.core.sort.call(null,this_floats),cljs.core.sort.call(null,that_floats))));
} else {
if(((cljs.core.set_QMARK_.call(null,this$)) && (cljs.core.set_QMARK_.call(null,that)))){
var vec__9863 = same.ish.split_floats.call(null,this$);
var this_floats = cljs.core.nth.call(null,vec__9863,(0),null);
var this_rest = cljs.core.nth.call(null,vec__9863,(1),null);
var vec__9866 = same.ish.split_floats.call(null,that);
var that_floats = cljs.core.nth.call(null,vec__9866,(0),null);
var that_rest = cljs.core.nth.call(null,vec__9866,(1),null);
var l = clojure.set.difference.call(null,this_rest,that_rest);
var r = clojure.set.difference.call(null,that_rest,this_rest);
var c = clojure.set.intersection.call(null,this_rest,that_rest);
var left = cljs.core.sort.call(null,this_floats);
var right = cljs.core.sort.call(null,that_floats);
while(true){
if(((cljs.core.empty_QMARK_.call(null,left)) || (cljs.core.empty_QMARK_.call(null,right)))){
return cljs.core.mapv.call(null,cljs.core.not_empty,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,l,left),cljs.core.into.call(null,r,right),c], null));
} else {
var vec__9875 = left;
var seq__9876 = cljs.core.seq.call(null,vec__9875);
var first__9877 = cljs.core.first.call(null,seq__9876);
var seq__9876__$1 = cljs.core.next.call(null,seq__9876);
var vl = first__9877;
var rl = seq__9876__$1;
var vec__9878 = right;
var seq__9879 = cljs.core.seq.call(null,vec__9878);
var first__9880 = cljs.core.first.call(null,seq__9879);
var seq__9879__$1 = cljs.core.next.call(null,seq__9879);
var vr = first__9880;
var rr = seq__9879__$1;
if(cljs.core.truth_(same.ish.ish.call(null,vl,vr))){
var G__9881 = l;
var G__9882 = r;
var G__9883 = cljs.core.conj.call(null,c,vr);
var G__9884 = rl;
var G__9885 = rr;
l = G__9881;
r = G__9882;
c = G__9883;
left = G__9884;
right = G__9885;
continue;
} else {
if((vl < vr)){
var G__9886 = cljs.core.conj.call(null,l,vl);
var G__9887 = r;
var G__9888 = c;
var G__9889 = rl;
var G__9890 = right;
l = G__9886;
r = G__9887;
c = G__9888;
left = G__9889;
right = G__9890;
continue;
} else {
var G__9891 = l;
var G__9892 = cljs.core.conj.call(null,r,vr);
var G__9893 = c;
var G__9894 = left;
var G__9895 = rr;
l = G__9891;
r = G__9892;
c = G__9893;
left = G__9894;
right = G__9895;
continue;

}
}
}
break;
}
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,same.diff.un_array.call(null,that),null], null);

}
}
}
}
}));

//# sourceMappingURL=diff.js.map
