--liquibase formatted sql

--changeset ciprian:init_insert_data_1
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO network_config (offline_mode, codescene_host_url)
  SELECT 0, 'http://localhost:3003'
  WHERE NOT EXISTS (SELECT * FROM network_config);

INSERT INTO access_management (restricted_project_access) VALUES (0);

INSERT INTO concurrent_analysis_scheduling (concurrent_analyses) VALUES (1);

INSERT INTO active_modules (simulation) VALUES (1);

--changeset ciprian:init_insert_data_2 dbms:mssql
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

SET IDENTITY_INSERT roles ON;

--changeset ciprian:init_insert_data_3
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO roles (id, name) VALUES (-1, 'No Access');
INSERT INTO roles (id, name) VALUES (1, 'Full Read-Only Access');
INSERT INTO roles (id, name) VALUES (2, 'Technical');
INSERT INTO roles (id, name) VALUES (3, 'Developer');
INSERT INTO roles (id, name) VALUES (4, 'Architect');
INSERT INTO roles (id, name) VALUES (5, 'Test Leader');
INSERT INTO roles (id, name) VALUES (6, 'Manager');
INSERT INTO roles (id, name) VALUES (7, 'Bot');
INSERT INTO roles (id, name) VALUES (8, 'Technical Lead');
INSERT INTO roles (id, name) VALUES (9, 'Admin');
INSERT INTO roles (id, name) VALUES (10, 'RestApi');

--changeset ciprian:init_insert_data_4 dbms:mssql
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

SET IDENTITY_INSERT roles OFF;
SET IDENTITY_INSERT auth_providers ON;

--changeset ciprian:init_insert_data_5
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO auth_providers (id, type, active, priority_order, default_role_id)
  VALUES (1, 'db', 1, 1, NULL);

INSERT INTO auth_providers (id, type, active, priority_order, default_role_id)
  VALUES (2, 'ldap', 0, 1, NULL);

UPDATE auth_providers
  SET default_role_id = (SELECT r.id from roles r where r.name = 'Full Read-Only Access');

--changeset ciprian:init_insert_data_6 dbms:mssql
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

SET IDENTITY_INSERT auth_providers OFF;
SET IDENTITY_INSERT notification_providers ON;

--changeset ciprian:init_insert_data_7
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO notification_providers (id, type, active, priority_order) VALUES (1, 'slack', 0, 1);

--changeset ciprian:init_insert_data_8 dbms:mssql
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

SET IDENTITY_INSERT notification_providers OFF;
SET IDENTITY_INSERT notifications ON;

--changeset ciprian:init_insert_data_9
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO notifications (id, name, display_name, description, template)
   VALUES
      (1,
      'analysis-result',
      'Analysis result',
      'Add the analysis result link to all other notifications.',
      'Project {{project-name}} analysis results: {{analysis-result-url}}'),
      (2,
      'analysis-run-ok',
      'Analysis success',
      'An analysis has finished without warnings.',
      'Your analysis has finished without warnings.'),
      (3,
      'analysis-run-error',
      'Analysis error',
      'An analysis has failed.',
      'Your analysis has failed with errors: {{project-url}}'),
      (4,
      'rising-spot-warning',
      'Rising Hotspot warning',
      'A Rising Hotspot is a module that rapidly becomes a hotspot. This is typically a sign of high development activity such as new features or bugfixes. When this warning fires, you need to ensure that the quality of the module is under control.',
      '{{notification/display-name}}: {{notification/description}}.'),
      (5,
      'complexity-trend-warning',
      'Complexity Trends warning',
      'One or more files show a rapid increase in complexity. It''s highly recommended that you inspect the code and prevent possible quality issues as soon as possible.',
      '{{notification/display-name}}: {{notification/description}}.'),
      (6,
      'exdevs-trend-warning',
      'Possible Ex-Developers warning',
      'We have detected a number of non-contributing authors in addition to your known ex-developers. Perhaps you want to mark these as ex-developers too?',
      '{{notification/display-name}}: {{notification/description}}.'),
      (7,
      'high-risk-commits-warning',
      'High Risk Commits warning',
      'There were recent commits that exceeded the configured threshold for an early warning.',
      '{{notification/display-name}}: {{notification/description}}.'),
      (8,
      'branch-ttl-warning',
      'Branch TTL warnings',
      'There are branches with active development that live longer than expected.',
      '{{notification/display-name}}: {{notification/description}}.'),
      (9,
      'supervised-hotspot-warning',
      'Supervised Hotspot warning',
      'You missed some goals with your supervised hotspots',
      '{{notification/display-name}}: {{notification/description}}.'),
      (10,
      'brooks-law-warning',
      'Brooks Law warning',
      'The number of developers have increased but the development output decreases',
      '{{notification/display-name}}: {{notification/description}}.'),
      (11,
      'development-output-warning',
      'Development Output warning',
      'The development output decreased over the past month',
      '{{notification/display-name}}: {{notification/description}}.'),
      (12,
      'weekly-onboarding-warning',
      'Weekly Development Output warning',
      'The number of developers have increased over the past week, with a decrease in development output (on-boarding cost?)',
      '{{notification/display-name}}: {{notification/description}}.');

--changeset ciprian:init_insert_data_10 dbms:mssql
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

SET IDENTITY_INSERT notifications OFF;

--changeset ciprian:init_insert_data_11
--preconditions onFail:MARK_RAN
--precondition-sql-check expectedResult:0 SELECT COUNT(*) FROM external_applications

INSERT INTO notification_providers_config
  VALUES
    (1, 'api-url', 'https://slack.com/api'),
    (1, 'api-token', NULL),
    (1, 'connection-timeout', '5000'),
    (1, 'socket-timeout', '5000');

INSERT INTO auth_provider_config
 VALUES
  (2, 'host', NULL),
  (2, 'port', '636'),
  (2, 'ssl?', 'on'),
  (2, 'connection-timeout', '5000'),
  (2, 'response-timeout', '5000'),
  (2, 'search-base', NULL),
  (2, 'bind-dn-format', NULL);

INSERT INTO auth_provider_role_mapping (provider_id, codescene_role_id, provider_role_name)
  SELECT 1, id, name from roles;

INSERT INTO auth_provider_role_mapping (provider_id, codescene_role_id, provider_role_name)
  SELECT 2, id, name FROM roles WHERE id != 10;

UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Users' WHERE provider_id = 2 and codescene_role_id = 1;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Technical' WHERE provider_id = 2 and codescene_role_id = 2;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Developers' WHERE provider_id = 2 and codescene_role_id = 3;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Architects' WHERE provider_id = 2 and codescene_role_id = 4;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Testers' WHERE provider_id = 2 and codescene_role_id = 5;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Managers' WHERE provider_id = 2 and codescene_role_id = 6;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Bots' WHERE provider_id = 2 and codescene_role_id = 7;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Technical Lead' WHERE provider_id = 2 and codescene_role_id = 8;
UPDATE auth_provider_role_mapping SET provider_role_name = 'CodeScene Admin' WHERE provider_id = 2 and codescene_role_id = 9;

INSERT INTO provider_notifications (provider_id, notification_id, active)
    VALUES
      (1, 1, 1),
      (1, 2, 0),
      (1, 3, 1),
      (1, 4, 1),
      (1, 5, 1),
      (1, 6, 1),
      (1, 7, 1),
      (1, 8, 1),
      (1, 9, 1),
      (1, 10, 1),
      (1, 11, 1),
      (1, 12, 1);

INSERT INTO external_applications (id, path) VALUES ('git', 'git');

INSERT INTO external_applications (id, path) VALUES ('google-repo', 'repo');
