lexer grammar SwiftSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

BACK_QUOTED : '`'  ~('\n'|'\r')*? '`';

LITERAL_CHAR : '\'' . '\'' -> skip;

FUNCTION: 'func';
EXTENSION: 'extension';
CLASS: 'class';
STRUCT: 'struct';
ENUM: 'enum';
INIT: 'init';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence