grammar ScalaComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals;
anything: .;

loops: FOR | FOREACH | WHILE;

paths: MATCH | THROW;

conditionals: IF | OPERATORS;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

IF: 'if';
FOR: 'for';
FOREACH: 'foreach';
WHILE: 'while';
MATCH: 'match';
THROW: 'throw';
RETURN: 'return';

OPERATORS: '&&' | '||';

ID : [a-zA-Z_][a-zA-Z0-9_]*;

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
