grammar CppMethodArguments;

import CppSharedRulesParser;

singlefunctionscope
:
	expression* EOF
;

expression : function_declaration
           | block_statement // since we support Google test which won't be a vald function
           | anything; // since we use micro-grammars we might get noise before a method

function_declaration : function_name function_definition_params_list throw_spec? trailing_return_type? LeftBrace function_body RightBrace;

// make sure we handle stuff like noexcept(sizeof(T) < 4)
throw_spec : (NOEXCEPT | THROW) ~(LeftBrace | ARROW)*?;

fun_arg : 'const'? (generic_args | parameter | function_pointer | dynamic) default_value?;
default_value: '=' ~(',' | LeftParen | RightParen)+? (LeftParen ~(RightParen)*? RightParen)?;

type_name: UNSIGNED? (ID | SCOPED_NAME) '[]'?;

generic_args: type_name generic_type type_modifiers*? parameter_name;
generic_type: '<' generic_arg_list '>';
generic_arg: ~('<' | '>')*? generic_type?;
generic_arg_list: generic_arg
                 | generic_arg_list ',' generic_arg;

parameter: type_name type_modifiers*? parameter_name;
dynamic: ID LeftParen parameter_name RightParen; // Most likely a macro like: void f(PARAM(x))

function_pointer: function_pointer_part+;
function_pointer_part: (ID | STAR | AMP)
                     | LeftParen function_pointer_part*? RightParen
                     | function_pointer_part ',' function_pointer_part;

// handle all kinds  of const T const* variations
array_modifier: '[' (INT | ID) ']';
type_modifiers: STAR | AMP | 'const' | 'volatile' | 'auto' | array_modifier;

parameter_name: ~(',' | RightParen | LeftParen)+?;

function_definition_params_list : LeftParen function_definition_params_list_details? RightParen;

function_definition_params_list_details : fun_arg
                                        | function_definition_params_list_details ',' fun_arg;

