grammar Apex;

translationunit
:
	expression* EOF
;

expression : function_declaration
           | variable_field
           | class_declaration
           | block_statement
           | anything;

anything : ~(LeftBrace | RightBrace);

// Variable fields are need for LCOM4 calculations:
variable_field: variable_name (';' | property_with_object_initialization | '=');
variable_name: ID;
property_with_object_initialization : '=' 'new' ID LeftParen function_definition_params_list? RightParen LeftBrace function_body RightBrace;

// getters/setters: needed for X-Ray + cohesion
property_accessor: ('get' | 'set') LeftBrace function_body RightBrace;
getters_and_or_setter: property_accessor+;

class_declaration : CLASS class_name ~(';')*? LeftBrace expression* RightBrace;
class_name : ID;

function_declaration : TRIGGER function_name 'on' ~LeftParen+? function_definition_params_list LeftBrace function_body RightBrace
                     | function_name function_definition_params_list LeftBrace function_body RightBrace
                     | function_type_signature function_name function_definition_params_list LeftBrace function_body RightBrace
                     | function_name LeftBrace getters_and_or_setter RightBrace;

function_type_signature : ~(LeftBrace | RightBrace | LeftParen | RightParen | SEMICOLON | TRIGGER | '=')+?;

function_name : '~'? (ID | SCOPED_NAME);

// Function arguments
//
fun_arg : 'final'? (generic_args | parameter);

type_name: (ID | SCOPED_NAME) '[]'?;

generic_args: type_name generic_type ID;
generic_type: '<' generic_arg_list '>';
generic_arg: ~('<' | '>')*? generic_type?;
generic_arg_list: generic_arg
                 | generic_arg_list ',' generic_arg;

argument_type: type_name;
parameter: argument_type ID;

function_definition_params_list : LeftParen function_definition_params_list_details? RightParen;

function_definition_params_list_details : fun_arg
                                        | function_definition_params_list_details ',' fun_arg;


// Function body
//
function_body : function_body_statement*?;

function_body_statement : block_statement
                        | any_statement;

block_statement : LeftBrace function_body_statement*? RightBrace;

any_statement : ~(LeftBrace | RightBrace | CLASS);

fragment ESCAPED : '\\\\' | '\\\'';
LITERAL : '\'' ( ESCAPED | ~('\''))*? '\'';

LITERAL_CHAR : '\'' . '\'' -> skip;

CLASS_TYPE_INFO: '.class'; // allow expressions like Integer.class
CLASS : 'class';

TRIGGER : 'trigger';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SCOPER : '.';
SCOPED_NAME : SCOPER? ID (SCOPER ID)+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
