(ns codescene.features.spec.components
  (:require [clojure.spec.alpha :as s]
            [codescene.crypto.encryptor :refer [Encryptor]])
  (:import (clojure.lang ILookup)))

(s/def ::encryptor #(satisfies? Encryptor %))

(s/def ::env #(instance? ILookup %))

(s/def ::project-component some?)
(s/def ::navigation-component some?)
(s/def ::analysis-component some?)
(s/def ::delta-analysis-component some?)

(s/def ::report-component
  (s/keys :req-un [::project-component ::navigation-component ::analysis-component ::delta-analysis-component]))
