(ns codescene.features.reports.code-health.period-stats-summary
  (:require
   [codescene.features.reports.pdf-helpers :as ph]
   [codescene.features.reports.common.styling :as styling]))


(defn- period-stat-numbers [current-period previous-period img-dir]
  (let [stat-number (styling/number->printable-string-100k (or current-period 0))
        change (- (or current-period 0) (or previous-period 0))
        change-icon (cond
                      (neg? change) (styling/load-resource img-dir "period-stats/Arrow-down-circle.png")
                      (pos? change) (styling/load-resource img-dir "period-stats/Arrow-up-circle.png")
                      :else (styling/load-resource img-dir "period-stats/No-change-circle.png"))
        change-text (cond
                      (neg? change) (styling/number->printable-string-100k change)
                      (pos? change) (format "+%s" (styling/number->printable-string-100k change))
                      :else "No change")]
    (ph/table
     [] [13 2 1 10]
     (ph/row
      (ph/cell [:mss-number-cell] (ph/paragraph [:mss-number-paragraph] stat-number))
      (ph/cell [:mss-changeicon-cell] (ph/image [:mss-changeicon-image] change-icon))
      ""
      (ph/cell [:mss-changetext-cell] (ph/paragraph [:mss-changetext-paragraph] change-text))))))


(defn- period-stat [title icon {:keys [current-period previous-period]} img-dir]
  (ph/table
   [] nil
   (ph/row
    (ph/table
     [] [1 3]
     (ph/row
      (ph/cell [:mss-icon-cell] (ph/image [:mss-icon-image] icon))
      (ph/cell
       []
       (ph/table
        [] nil
        (ph/row (ph/cell [:mss-title-cell] (ph/paragraph [:mss-title-paragraph] title)))
        (ph/row (ph/cell [] (period-stat-numbers current-period previous-period img-dir))))))))
   (ph/row (ph/cell [] [:spacer 1] (ph/line [:c-line]) [:spacer 1]))
   (ph/row (ph/cell [] (ph/paragraph [:mss-description-paragraph] "Trend compared to: previous period")))))


(defn- stat-data [this-period-statistics previous-period-statistics]
  {:contributors {:current-period (:contributors this-period-statistics)
                  :previous-period (:contributors previous-period-statistics)}
   :commits {:current-period (:commits this-period-statistics)
             :previous-period (:commits previous-period-statistics)}
   :pull-requests {:current-period (:pull-requests this-period-statistics)
                   :previous-period (:pull-requests previous-period-statistics)}})


(defn pdf-element [this-period-statistics previous-period-statistics {img-dir :img-dir}]
  (let [{:keys [contributors commits pull-requests]} (stat-data this-period-statistics previous-period-statistics)
        contributors-icon (styling/load-resource img-dir "period-stats/Users.png")
        commits-icon (styling/load-resource img-dir "period-stats/Folder-cloud.png")
        pr-icon (styling/load-resource img-dir "period-stats/Pull-request.png")]
    (ph/table
     [:c-card-content-top-table] nil
     (ph/row
      (ph/cell
       []
       (ph/paragraph [:c-miniheader] "SUMMARY")
       [:spacer 1]))
     (ph/row
      (ph/table
       [] [5 1 5 1 5]
       (ph/row
        (ph/cell [:mss-cell] (period-stat "Total Contributors" contributors-icon contributors img-dir))
        ""
        (ph/cell [:mss-cell] (period-stat "Total number of commits" commits-icon commits img-dir))
        ""
        (ph/cell [:mss-cell] (period-stat "Number of PRs" pr-icon pull-requests img-dir))))))))