(ns codescene.features.pm-data.azure.pr-data-provider
  (:require [codescene.features.pm-data.pr-data-provider :refer [-create PrDataProvider]]
            [codescene.features.pm-data.azure.azure-cache :as cache]
            [codescene.features.pm-data.azure.azure-fetcher :as fetcher]
            [codescene.url.url-utils :as url]))

(defn- validate-settings
  "Validate settings by trying to fetch the latest PR data"
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pr-data-context}]
  (when-let [repo-info(-> repo-urls first url/azure-url->parts)]
    (fetcher/fetch-pull-requests api-client repo-info 1)))

(defn- get-pull-requests
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pm-data-context}]
  (->> repo-urls
       (map url/azure-url->parts)
       (mapcat #(cache/fetch-pull-requests api-client % _provider-def))
       (into [])))

(deftype AzureProvider [provider-def pr-data-context]
  PrDataProvider
  (-validate-settings [_this] (validate-settings provider-def pr-data-context))
  (-get-pull-requests [_this _since] (get-pull-requests provider-def pr-data-context)))

(defmethod -create "azure"
  [provider-def pr-data-context]
  (->AzureProvider provider-def pr-data-context))

(comment
  (def api-client {:api-client ["" (System/getenv "AZURE_TOKEN")]})
  (def context {:repo-urls ["git@ssh.dev.azure.com:v3/empear/SmartHotel360/PublicWeb"]})
  (validate-settings api-client context)
  (get-pull-requests api-client context)
  )
