(ns codescene.features.components.thread-pool
  (:require [com.climate.claypoole :as cp]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [codescene.features.components.core :refer [find-component]]))

(defmethod ig/init-key ::thread-pool [_ {:keys [n-threads-in-shared-thread-pool]}]
  (let [n-threads (or
                    n-threads-in-shared-thread-pool
                    (- (cp/ncpus) 1))]
    (log/info "Creating code health thread pool with " n-threads " threads")
    (cp/threadpool (max n-threads 1)))) ; at least one thread or we'll lock :(

(defmethod ig/halt-key! ::thread-pool [_ thread-pool]
  (cp/shutdown thread-pool))

(derive ::thread-pool :codescene/component)

(defn component [system] (find-component system ::thread-pool))




