(ns codescene.features.components.developer-settings
  (:require [clojure.spec.alpha :as s]
            [codescene.features.spec.commons :as commons-spec]))

(s/def ::exclude_from_all_analyses boolean?)
(s/def ::former_contributor boolean?)
(s/def ::team_name (s/nilable string?))
(s/def ::teamid (s/nilable int?))
(s/def ::excluded boolean?)
(s/def ::exdev boolean?)
(s/def ::developer-settings (s/keys :req-un [::commons-spec/id ::commons-spec/name]))
(s/def ::team (s/keys :req-un [::commons-spec/id ::commons-spec/name]))
(s/def ::developer (s/keys :req-un [::commons-spec/id ::commons-spec/name ::excluded ::exdev ::team_name ::teamid]))

(defprotocol DeveloperSettingsComponent
  (-developer-settings-list [this user])
  (-project-ids-using [this developer-settings-id])
  (-delete [this developer-settings-id])

  (-all-teams [this developer-settings-id])
  (-add-team [this developer-settings-id team])
  (-update-team [this developer-settings-id team])
  (-delete-team [this developer-settings-id team-id])

  (-known-developers [this developer-settings-id])
  (-update-developer [this developer-settings-id developer])
  (-delete-developer [this developer-settings-id developer-id]))

(s/fdef developer-settings-list
        :args (s/cat :this some?
                     :user some?)
        :ret (s/nilable (s/coll-of ::developer-settings)))
(defn developer-settings-list
  "return the list of developer settings"
  [this user]
  (-developer-settings-list this user))

(s/fdef project-ids-using
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id)
        :ret (s/nilable (s/coll-of ::commons-spec/id)))
(defn project-ids-using
  "return the list of project ids using the given developer-settings-id"
  [this developer-settings-id]
  (-project-ids-using this developer-settings-id))

(s/fdef delete
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id)
        :ret (s/tuple boolean? string?))
(defn delete
  "delete developer-settings by id"
  [this developer-settings-id]
  (-delete this developer-settings-id))

(s/fdef all-teams
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id)
        :ret (s/nilable (s/coll-of ::team)))
(defn all-teams
  "return the list of the teams"
  [this developer-settings-id]
  (-all-teams this developer-settings-id))

(s/fdef add-team
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id
                     :team (s/keys :req-un [::commons-spec/name])))
(defn add-team
  "add team"
  [this developer-settings-id team]
  (-add-team this developer-settings-id team))

(s/fdef update-team
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id
                     :team ::team))
(defn update-team
  "update team"
  [this developer-settings-id team]
  (-update-team this developer-settings-id team))

(s/fdef delete-team
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id
                     :team-id ::commons-spec/id)
        :ret (s/tuple boolean? string?))
(defn delete-team
  "delete a team by id"
  [this developer-settings-id team-id]
  (-delete-team this developer-settings-id team-id))

(s/fdef known-developers
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id)
        :ret (s/nilable (s/coll-of ::developer)))
(defn known-developers
  "return the list of known developers"
  [this developer-settings-id]
  (-known-developers this developer-settings-id))

(s/fdef update-developer
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id
                     :developers ::developer))
(defn update-developer
  "update developer"
  [this developer-settings-id developer]
  (-update-developer this developer-settings-id developer))

(s/fdef delete-developer
        :args (s/cat :this some?
                     :developer-settings-id ::commons-spec/id
                     :developer-id ::commons-spec/id))
(defn delete-developer
  "delete a developer by id"
  [this developer-settings-id developer-id]
  (-delete-developer this developer-settings-id developer-id))
