(ns codescene.features.chat.service.messages
  "Message preparation for chat service.
   
   Handles building and enhancing message sequences with tool descriptions."
  (:require [codescene.features.chat.service.prompt.system :as system]
            [codescene.features.chat.service.prompt.tools :as tools]))

(defn- replace-system-content
  "Returns msg with updated content if it's a system message, otherwise unchanged."
  [enhanced-system msg]
  (if (= :system (:role msg))
    {:role :system :content enhanced-system}
    msg))

(defn- ensure-system-message
  "Ensures messages contain a system message with the enhanced content.
   If a system message exists, replaces its content. Otherwise prepends one."
  [messages enhanced-system]
  (if (some #(= :system (:role %)) messages)
    (mapv (partial replace-system-content enhanced-system) messages)
    (vec (cons {:role :system :content enhanced-system} messages))))

(defn prepare-with-tools
  "Prepares messages by enhancing the system prompt with tool descriptions."
  [messages tools]
  (let [system-msg (first (filter #(= :system (:role %)) messages))
        base-system (or (:content system-msg) system/default-prompt)
        enhanced-system (tools/build-system-prompt-with-tools base-system tools)]
    (ensure-system-message messages enhanced-system)))
