(ns codescene.features.api.spec.chat
  "Specs for chat API routes."
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec]))

;; Common specs
(s/def ::auth_token spec/string?)
(s/def ::instance_url spec/string?)

;; Message specs
(s/def ::role #{:user :assistant :system "user" "assistant" "system"})
(s/def ::content spec/string?)
(s/def ::message (s/keys :req-un [::role ::content]))
(s/def ::messages (s/coll-of ::message))

;; LLM config specs
(s/def ::provider spec/string?)
(s/def ::model spec/string?)
(s/def ::api_key spec/string?)
(s/def ::base_url spec/string?)
(s/def ::llm_config (s/keys :req-un [::model]
                            :opt-un [::provider ::api_key ::base_url]))

;; Chat request specs
(s/def ::conversation_id spec/string?)
(s/def ::project_id spec/int?)

(s/def ::chat-request (s/keys :req-un [::messages]
                              :opt-un [::conversation_id ::project_id ::llm_config
                                       ::auth_token ::instance_url]))

;; Chat response specs
(s/def ::response_content spec/string?)
(s/def ::tool_calls (s/coll-of map?))
(s/def ::chat-response (s/keys :opt-un [::response_content ::tool_calls ::conversation_id]))

;; Prompt argument specs
(s/def ::argument_name spec/string?)
(s/def ::argument_description (s/nilable spec/string?))
(s/def ::required (s/nilable spec/boolean?))
(s/def ::prompt-argument (s/keys :req-un [::argument_name]
                                 :opt-un [::argument_description ::required]))
(s/def ::arguments (s/coll-of ::prompt-argument))

;; Prompt specs
(s/def ::name spec/string?)
(s/def ::title (s/nilable spec/string?))
(s/def ::description (s/nilable spec/string?))
(s/def ::prompt (s/keys :req-un [::name]
                        :opt-un [::title ::description ::arguments]))
(s/def ::prompts (s/coll-of ::prompt))

;; Prompts list response
(s/def ::prompts-list-response (s/keys :req-un [::prompts]))

;; Get prompt params
(s/def ::prompt_name spec/string?)

;; Prompt message specs
(s/def ::prompt-message-role #{:user :assistant "user" "assistant"})
(s/def ::prompt-message-type #{"text" "image" "resource"})
(s/def ::text spec/string?)
(s/def ::prompt-content-item (s/keys :req-un [::prompt-message-type]
                                     :opt-un [::text]))
(s/def ::prompt-message-content (s/coll-of ::prompt-content-item))
(s/def ::prompt-message (s/keys :req-un [::prompt-message-role ::prompt-message-content]))
(s/def ::prompt-messages (s/coll-of ::prompt-message))

;; Get prompt response
(s/def ::success spec/boolean?)
(s/def ::error spec/string?)
(s/def ::result (s/keys :opt-un [::description ::prompt-messages]))
(s/def ::get-prompt-response (s/keys :req-un [::success]
                                     :opt-un [::result ::error]))
