(ns codescene.features.api.developer-settings
  (:require [codescene.features.util.api :as api-utils]
            [codescene.features.api.core :as api-core]
            [codescene.features.components.developer-settings :as developer-settings]
            [codescene.features.components.project :as project]
            [codescene.features.components.auth :as auth]))

(defn- with-ref
  [api-prefix developer-settings]
  (assoc developer-settings :ref (str (api-utils/developer-settings-url-prefix api-prefix) (:id developer-settings))))

(defn- developer-settings-list
  [system request]
  (let [developer-settings-component (api-core/api-developer-settings system)
        auth-component (api-core/api-auth system)
        user (auth/user auth-component request)]
    (->> (developer-settings/developer-settings-list developer-settings-component user)
         (map #(select-keys % [:id :name])))))

(defn list-result
  [system request {:keys [page filter-str]}]
  (let [developer-settings (developer-settings-list system request)
        api-prefix (api-core/api-root system)]
    (api-utils/paginated-list-result developer-settings {:page page
                                                         :filter-str filter-str
                                                         :list-kw :developer_settings
                                                         :processing-fn (partial with-ref api-prefix)})))

(defn delete-result
  [system developer-settings-id]
  (let [developer-settings-component (api-core/api-developer-settings system)
        used-in-projects (->> (developer-settings/project-ids-using developer-settings-component developer-settings-id)
                              (map #(-> (api-core/api-projects system) (project/project-by-id %) :name))
                              vec)
        [success reason] (if (empty? used-in-projects)
                           (developer-settings/delete developer-settings-component developer-settings-id)
                           [false (format "Cannot delete developer-settings with id: %s because it is linked to projects: %s" developer-settings-id used-in-projects)])]
    (if success
      (api-utils/ok {:ok "developer-settings-deleted"})
      (api-utils/bad-request reason))))
