// @flow

import * as topMenu from 'codescene-ui/src/shared/top-menu/top-menu.jsx';
import * as customTabs from 'codescene-ui/src/shared/custom-tabs/custom-tabs';
import * as browserSupportAlert from 'codescene-ui/src/shared/browser-support-alert/browser-support-alert.jsx';
import * as developerConfigurations from 'codescene-ui/src/general/developer-configurations/developer-configurations.jsx';
import * as reportConfig from 'codescene-ui/src/configuration/reports/report-config.jsx';
import * as codeBlock from 'codescene-ui/src/shared/code-tools/code-block';
import * as performedRefactorings from 'codescene-ui/src/analyses/refactorings/refactorings.jsx';
import * as projectsPage from 'codescene-ui/src/analyses/four-factor/projects-page/projects/projects';
import * as markdown from 'codescene-ui/src/shared/markdown/markdown.tsx';
import * as loginShared from 'codescene-ui/src/general/onprem-login/index.jsx';
import * as welcomePage from 'codescene-ui/src/general/onprem-welcome/index.jsx';
import * as notifications from 'codescene-ui/src/shared/notification/index';
import * as dataGatheringForm from 'codescene-ui/src/configuration/data-gathering-form/data-gathering-form.jsx';
import * as userAnalytics from 'codescene-ui/src/analytics';
import * as customDefaultSettings from 'codescene-ui/src/configuration/system/customDefaultSettings';
import * as customizableQualityProfiles from 'codescene-ui/src/configuration/pr-integration/customizable-quality-profiles';
import * as codeCoverageConfig from 'codescene-ui/src/configuration/code-coverage/init';


import * as analyses from './analyses';
import * as developerConfiguration from './developer-configuration';

import * as projects from './projects';
import * as configurations from './configurations';
import * as login from './login-view';
import * as duration from './project-analysis-duration';
import * as activeAuthors from './active-authors-view';
import * as groups from './groups-view';

// Import chat widget to register the <x-ai-chat-btn> custom element
import 'codescene-ui/src/shared/chat-widget';

export {
  analyses,
  projects,
  configurations,
  topMenu,
  login,
  duration,
  activeAuthors,
  customTabs,
  browserSupportAlert,
  developerConfiguration,
  developerConfigurations,
  reportConfig,
  groups,
  codeBlock,
  performedRefactorings,
  markdown,
  customDefaultSettings,
  // 4F projects page
  projectsPage,
  loginShared,
  welcomePage,
  notifications,
  dataGatheringForm,
  userAnalytics,
  customizableQualityProfiles,
  codeCoverageConfig,
};
