// @flow
import $ from 'jquery';
import d3 from 'd3';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import * as stackedTrends from 'codescene-ui/src/analyses/stacked-trends';

const parseDate = d3.time.format('%Y-%m-%d').parse;

export function parseRow(row : any) {
  return {
    comments: parseInt(row.comments),
    date: parseDate(row.date),
    n: parseInt(row.n),
    total: parseFloat(row.total),
    ratio: parseFloat(row.ratio),
    dateString: row.date
  };
}

type ViewOptions = {
  locUrl: string
};

export function init(options : ViewOptions) {
  const content = $('.content');
  const detailMessage = 'You need to define Architectural Components and enable the Architectural Trends analysis in your project configuration, then run a new analysis.';
  xhr.csv(options.locUrl)
    .then(locData => {
      if (locData && locData.length > 0) {
        const parseDate = d3.time.format('%Y-%m-%d').parse;
        locData.forEach(function(d) {
          d.date = parseDate(d.date);
        });
        stackedTrends.draw($('#locline'), 'Lines of Code', locData);
      } else {
        alerts.warning(content, `<strong>This analysis is disabled.</strong> ${detailMessage}`);
      }
    })
    .catch(err => {
      console.error(err);
      alerts.warning(content, `<strong>No component trends available.</strong> ${detailMessage}`);
    });
}
