// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';

import * as tableSorter from 'codescene-ui/src/table-sorter';

type ViewOptions = {
  summaryUrl : string
};

function parseSummaryMetricRow(row) {
  return {
    statistic: row.statistic,
    value: parseInt(row.value)
  };
}

export function init(options : ViewOptions) {
  const container = $('#summary');
  xhr.csv(options.summaryUrl, parseSummaryMetricRow)
    .then(data => {
      const table = $('<table>')
        .addClass('table table-striped');

      const tBody = $('<tbody></tbody>');
      tBody.appendTo(table);

      $.each(data, (i, row) => {
        const tr = $('<tr>')
          .append($('<th>').text(row.statistic))
          .append($('<td>').text(row.value.toLocaleString()));
        tBody.append(tr);
      });

      tableSorter.sort(table, {});

      container.append(table);
    });
}
