function messageReceived(message, timeReceived) {
   // Refactoring #1: encapsulate the business rule in a
   // function. A clear name replaces the need for the comment:
   if (!knownCustomer(message)) {
     log('spam received -- ignoring');
     return;
   }

  // Refactoring #2: encapsulate the business rule.
  // Again, note how a clear function name replaces the
  // need for a code comment:
  if (outsideBusinessHours(timeReceived)) {
    return autoReplyTo(message);
  }

  pingAgentFor(message);
}

function outsideBusinessHours(timeReceived) {
  // Refactoring #3: replace magic numbers with
  // symbols that communicate with the code reader:
  const closingHour = 17;
  const openingHour = 8;

  const hours = timeReceived.getHours();

  // Refactoring #4: simple conditional rules can
  // be further clarified by introducing a variable:
  const afterClosing = hours > closingHour;
  const beforeOpening = hours < openingHour;

  // Yeah -- look how clear the business rule is now!
  return afterClosing || beforeOpening;
}